/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.io.NullOutputStream;

public class DefaultStreamHasher
implements StreamHasher {
    private static final HashCode SIGNATURE = Hashing.signature(DefaultStreamHasher.class);
    private final Queue<byte[]> buffers = new ArrayBlockingQueue<byte[]>(16);

    @Override
    public HashCode hash(InputStream inputStream) {
        try {
            return this.doHash(inputStream, NullOutputStream.INSTANCE);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create MD5 hash for file content.", e);
        }
    }

    @Override
    public HashCode hashCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return this.doHash(inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashCode doHash(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = this.takeBuffer();
        try {
            int nread;
            PrimitiveHasher hasher = Hashing.newPrimitiveHasher();
            hasher.putHash(SIGNATURE);
            while ((nread = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, nread);
                hasher.putBytes(buffer, 0, nread);
            }
            HashCode hashCode = hasher.hash();
            return hashCode;
        }
        finally {
            this.returnBuffer(buffer);
        }
    }

    private void returnBuffer(byte[] buffer) {
        this.buffers.offer(buffer);
    }

    private byte[] takeBuffer() {
        byte[] buffer = this.buffers.poll();
        if (buffer == null) {
            buffer = new byte[8192];
        }
        return buffer;
    }
}

