/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.internal.IoActions;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;

public class DefaultFileHasher
implements FileHasher {
    private final StreamHasher streamHasher;

    public DefaultFileHasher(StreamHasher streamHasher) {
        this.streamHasher = streamHasher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashCode hash(File file) {
        HashCode hashCode;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            hashCode = this.streamHasher.hash(inputStream);
        }
        catch (Throwable throwable) {
            try {
                IoActions.closeQuietly(inputStream);
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(String.format("Failed to create MD5 hash for file '%s' as it does not exist.", file), e);
            }
        }
        IoActions.closeQuietly(inputStream);
        return hashCode;
    }

    @Override
    public HashCode hash(File file, FileMetadataSnapshot fileDetails) {
        return this.hash(file);
    }

    @Override
    public HashCode hash(FileTreeElement fileDetails) {
        return this.hash(fileDetails.getFile());
    }
}

