/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public abstract class AbstractFileSystemLocationFingerprint
implements FileSystemLocationFingerprint {
    private final FileType type;
    private final HashCode normalizedContentHash;

    public AbstractFileSystemLocationFingerprint(FileType type, HashCode normalizedContentHash) {
        this.type = type;
        this.normalizedContentHash = normalizedContentHash;
    }

    @Override
    public final void appendToHasher(Hasher hasher) {
        hasher.putString(this.getNormalizedPath());
        hasher.putHash(this.getNormalizedContentHash());
    }

    @Override
    public HashCode getNormalizedContentHash() {
        return this.normalizedContentHash;
    }

    @Override
    public FileType getType() {
        return this.type;
    }

    @Override
    public final int compareTo(FileSystemLocationFingerprint o) {
        int result = this.getNormalizedPath().compareTo(o.getNormalizedPath());
        if (result == 0) {
            result = this.getNormalizedContentHash().compareTo(o.getNormalizedContentHash());
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileSystemLocationFingerprint that = (AbstractFileSystemLocationFingerprint)o;
        return this.normalizedContentHash.equals(that.normalizedContentHash) && this.getNormalizedPath().equals(that.getNormalizedPath());
    }

    public final int hashCode() {
        int result = this.normalizedContentHash.hashCode();
        result = 31 * result + this.getNormalizedPath().hashCode();
        return result;
    }

    public final String toString() {
        return String.format("'%s' / %s", this.getNormalizedPath(), this.type == FileType.Directory ? "DIR" : (this.type == FileType.Missing ? "MISSING" : this.normalizedContentHash));
    }
}

