/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.FileChange;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public class AbsolutePathFingerprintCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new AbsolutePathFingerprintCompareStrategy();

    private AbsolutePathFingerprintCompareStrategy() {
    }

    @Override
    protected boolean doVisitChangesSince(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> current, Map<String, FileSystemLocationFingerprint> previous, String propertyTitle, boolean includeAdded) {
        LinkedHashSet<String> unaccountedForPreviousFingerprints = new LinkedHashSet<String>(previous.keySet());
        for (Map.Entry<String, FileSystemLocationFingerprint> currentEntry : current.entrySet()) {
            FileSystemLocationFingerprint previousFingerprint;
            HashCode previousContentHash;
            String currentAbsolutePath = currentEntry.getKey();
            FileSystemLocationFingerprint currentFingerprint = currentEntry.getValue();
            HashCode currentContentHash = currentFingerprint.getNormalizedContentHash();
            if (!(unaccountedForPreviousFingerprints.remove(currentAbsolutePath) ? !currentContentHash.equals(previousContentHash = (previousFingerprint = previous.get(currentAbsolutePath)).getNormalizedContentHash()) && !visitor.visitChange(FileChange.modified(currentAbsolutePath, propertyTitle, previousFingerprint.getType(), currentFingerprint.getType())) : includeAdded && !visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, currentFingerprint.getType())))) continue;
            return false;
        }
        for (String previousAbsolutePath : unaccountedForPreviousFingerprints) {
            if (visitor.visitChange(FileChange.removed(previousAbsolutePath, propertyTitle, previous.get(previousAbsolutePath).getType()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
        NormalizedPathFingerprintCompareStrategy.appendSortedToHasher(hasher, fingerprints);
    }
}

