/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.JarHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.RuntimeClasspathResourceHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.classpath.impl.ClasspathCompareStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class ClasspathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    private final NonJarFingerprintingStrategy nonJarFingerprintingStrategy;
    private final ResourceFilter classpathResourceFilter;
    private final ResourceSnapshotterCacheService cacheService;
    private final ResourceHasher classpathResourceHasher;
    private final JarHasher jarHasher;
    private final StringInterner stringInterner;
    private final HashCode jarHasherConfigurationHash;

    private ClasspathFingerprintingStrategy(String identifier, NonJarFingerprintingStrategy nonJarFingerprintingStrategy, ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        super(identifier, ClasspathCompareStrategy.INSTANCE);
        this.nonJarFingerprintingStrategy = nonJarFingerprintingStrategy;
        this.classpathResourceFilter = classpathResourceFilter;
        this.classpathResourceHasher = classpathResourceHasher;
        this.cacheService = cacheService;
        this.stringInterner = stringInterner;
        this.jarHasher = new JarHasher(classpathResourceHasher, classpathResourceFilter);
        Hasher hasher = Hashing.newHasher();
        this.jarHasher.appendConfigurationToHasher(hasher);
        this.jarHasherConfigurationHash = hasher.hash();
    }

    public static ClasspathFingerprintingStrategy runtimeClasspath(ResourceFilter classpathResourceFilter, RuntimeClasspathResourceHasher runtimeClasspathResourceHasher, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        return new ClasspathFingerprintingStrategy("CLASSPATH", NonJarFingerprintingStrategy.USE_FILE_HASH, runtimeClasspathResourceHasher, classpathResourceFilter, cacheService, stringInterner);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher classpathResourceHasher, ResourceSnapshotterCacheService cacheService, StringInterner stringInterner) {
        return new ClasspathFingerprintingStrategy("COMPILE_CLASSPATH", NonJarFingerprintingStrategy.IGNORE, classpathResourceHasher, ResourceFilter.FILTER_NOTHING, cacheService, stringInterner);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(Iterable<FileSystemSnapshot> roots) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<String> processedEntries = new HashSet<String>();
        for (FileSystemSnapshot root : roots) {
            ClasspathFingerprintVisitor fingerprintVisitor = new ClasspathFingerprintVisitor(processedEntries, (ImmutableMap.Builder<String, FileSystemLocationFingerprint>)builder);
            root.accept(new ClasspathContentFingerprintingVisitor(fingerprintVisitor));
        }
        return builder.build();
    }

    @Nullable
    private HashCode fingerprintRootFile(RegularFileSnapshot fileSnapshot) {
        if (FileUtils.hasExtensionIgnoresCase(fileSnapshot.getName(), ".jar")) {
            return this.fingerprintJarContents(fileSnapshot);
        }
        return this.nonJarFingerprintingStrategy.determineNonJarFingerprint(fileSnapshot.getHash());
    }

    @Nullable
    private HashCode fingerprintJarContents(RegularFileSnapshot fileSnapshot) {
        return this.cacheService.hashFile(fileSnapshot, this.jarHasher, this.jarHasherConfigurationHash);
    }

    private class ClasspathFingerprintVisitor {
        private final RelativePathStringTracker relativePathStringTracker;
        private final HashSet<String> processedEntries;
        private final ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder;

        public ClasspathFingerprintVisitor(HashSet<String> processedEntries, ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder) {
            this.processedEntries = processedEntries;
            this.builder = builder;
            this.relativePathStringTracker = new RelativePathStringTracker();
        }

        public boolean preVisitDirectory(FileSystemLocationSnapshot directorySnapshot) {
            this.relativePathStringTracker.enter(directorySnapshot);
            return true;
        }

        public void visit(FileSystemLocationSnapshot fileSnapshot, HashCode normalizedContentHash) {
            String absolutePath = fileSnapshot.getAbsolutePath();
            if (this.processedEntries.add(absolutePath)) {
                FileSystemLocationFingerprint fingerprint = this.relativePathStringTracker.isRoot() ? IgnoredPathFileSystemLocationFingerprint.create(fileSnapshot.getType(), normalizedContentHash) : this.createFileFingerprint(fileSnapshot, normalizedContentHash);
                this.builder.put((Object)absolutePath, (Object)fingerprint);
            }
        }

        private FileSystemLocationFingerprint createFileFingerprint(FileSystemLocationSnapshot snapshot, HashCode content) {
            this.relativePathStringTracker.enter(snapshot);
            DefaultFileSystemLocationFingerprint fingerprint = new DefaultFileSystemLocationFingerprint(ClasspathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), FileType.RegularFile, content);
            this.relativePathStringTracker.leave();
            return fingerprint;
        }

        public void postVisitDirectory() {
            this.relativePathStringTracker.leave();
        }
    }

    private class ClasspathContentFingerprintingVisitor
    implements FileSystemSnapshotVisitor {
        private final ClasspathFingerprintVisitor delegate;
        private final RelativePathSegmentsTracker relativePathSegmentsTracker = new RelativePathSegmentsTracker();
        private final Factory<String[]> relativePathFactory = new Factory<String[]>(){

            @Override
            public String[] create() {
                return (String[])Iterables.toArray(ClasspathContentFingerprintingVisitor.this.relativePathSegmentsTracker.getRelativePath(), String.class);
            }
        };

        public ClasspathContentFingerprintingVisitor(ClasspathFingerprintVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.enter(directorySnapshot);
            return this.delegate.preVisitDirectory(directorySnapshot);
        }

        @Override
        public void visit(FileSystemLocationSnapshot fileSnapshot) {
            HashCode normalizedContent;
            if (fileSnapshot.getType() == FileType.RegularFile && (normalizedContent = this.fingerprintFile((RegularFileSnapshot)fileSnapshot)) != null) {
                this.delegate.visit(fileSnapshot, normalizedContent);
            }
        }

        @Nullable
        private HashCode fingerprintFile(RegularFileSnapshot fileSnapshot) {
            return this.relativePathSegmentsTracker.isRoot() ? ClasspathFingerprintingStrategy.this.fingerprintRootFile(fileSnapshot) : this.fingerprintTreeFile(fileSnapshot);
        }

        @Nullable
        private HashCode fingerprintTreeFile(RegularFileSnapshot fileSnapshot) {
            this.relativePathSegmentsTracker.enter(fileSnapshot);
            boolean shouldBeIgnored = ClasspathFingerprintingStrategy.this.classpathResourceFilter.shouldBeIgnored(this.relativePathFactory);
            this.relativePathSegmentsTracker.leave();
            if (shouldBeIgnored) {
                return null;
            }
            return ClasspathFingerprintingStrategy.this.classpathResourceHasher.hash(fileSnapshot);
        }

        @Override
        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.leave();
            this.delegate.postVisitDirectory();
        }
    }

    public static enum NonJarFingerprintingStrategy {
        IGNORE{

            @Override
            @Nullable
            public HashCode determineNonJarFingerprint(HashCode original) {
                return null;
            }
        }
        ,
        USE_FILE_HASH{

            @Override
            public HashCode determineNonJarFingerprint(HashCode original) {
                return original;
            }
        };


        @Nullable
        public abstract HashCode determineNonJarFingerprint(HashCode var1);
    }
}

