/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.FileChange;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintCompareStrategy;
import org.gradle.internal.hash.Hasher;

public class ClasspathCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new ClasspathCompareStrategy();

    private ClasspathCompareStrategy() {
    }

    @Override
    protected boolean doVisitChangesSince(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> currentSnapshots, Map<String, FileSystemLocationFingerprint> previousSnapshots, String propertyTitle, boolean includeAdded) {
        block5: {
            Iterator<Map.Entry<String, FileSystemLocationFingerprint>> currentEntries = currentSnapshots.entrySet().iterator();
            Iterator<Map.Entry<String, FileSystemLocationFingerprint>> previousEntries = previousSnapshots.entrySet().iterator();
            while (true) {
                if (currentEntries.hasNext()) {
                    Map.Entry<String, FileSystemLocationFingerprint> current = currentEntries.next();
                    String currentAbsolutePath = current.getKey();
                    if (previousEntries.hasNext()) {
                        String previousNormalizedPath;
                        Map.Entry<String, FileSystemLocationFingerprint> previous = previousEntries.next();
                        FileSystemLocationFingerprint currentFingerprint = current.getValue();
                        FileSystemLocationFingerprint previousFingerprint = previous.getValue();
                        String currentNormalizedPath = currentFingerprint.getNormalizedPath();
                        if (currentNormalizedPath.equals(previousNormalizedPath = previousFingerprint.getNormalizedPath())) {
                            if (currentFingerprint.getNormalizedContentHash().equals(previousFingerprint.getNormalizedContentHash()) || visitor.visitChange(FileChange.modified(currentAbsolutePath, propertyTitle, previousFingerprint.getType(), currentFingerprint.getType()))) continue;
                            return false;
                        }
                        String previousAbsolutePath = previous.getKey();
                        if (!visitor.visitChange(FileChange.removed(previousAbsolutePath, propertyTitle, previousFingerprint.getType()))) {
                            return false;
                        }
                        if (!includeAdded || visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, currentFingerprint.getType()))) continue;
                        return false;
                    }
                    if (!includeAdded || visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, current.getValue().getType()))) continue;
                    return false;
                }
                if (!previousEntries.hasNext()) break block5;
                Map.Entry<String, FileSystemLocationFingerprint> previousEntry = previousEntries.next();
                if (!visitor.visitChange(FileChange.removed(previousEntry.getKey(), propertyTitle, previousEntry.getValue().getType()))) break;
            }
            return false;
        }
        return true;
    }

    @Override
    public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> fingerprints) {
        for (FileSystemLocationFingerprint fingerprint : fingerprints) {
            fingerprint.appendToHasher(hasher);
        }
    }
}

