/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl.steps;

import java.util.Optional;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.impl.steps.Context;
import org.gradle.internal.execution.impl.steps.Step;

public class ExecuteStep
implements Step<Context, Result> {
    private final OutputChangeListener outputChangeListener;

    public ExecuteStep(OutputChangeListener outputChangeListener) {
        this.outputChangeListener = outputChangeListener;
    }

    @Override
    public Result execute(Context context) {
        UnitOfWork work = context.getWork();
        Optional<? extends Iterable<String>> changingOutputs = work.getChangingOutputs();
        changingOutputs.ifPresent(outputs -> this.outputChangeListener.beforeOutputChange((Iterable<String>)outputs));
        if (!changingOutputs.isPresent()) {
            this.outputChangeListener.beforeOutputChange();
        }
        final ExecutionOutcome outcome = work.execute();
        return new Result(){

            @Override
            public Try<ExecutionOutcome> getOutcome() {
                return Try.successful(outcome);
            }
        };
    }
}

