/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;

public class OutputFilterUtil {
    public static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> filterOutputFingerprints(final @Nullable ImmutableSortedMap<String, FileCollectionFingerprint> outputsAfterPreviousExecution, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputsBeforeExecution, final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputsAfterExecution) {
        return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(outputsBeforeExecution, (Maps.EntryTransformer)new Maps.EntryTransformer<String, CurrentFileCollectionFingerprint, CurrentFileCollectionFingerprint>(){

            public CurrentFileCollectionFingerprint transformEntry(String propertyName, CurrentFileCollectionFingerprint outputBeforeExecution) {
                CurrentFileCollectionFingerprint outputAfterExecution = (CurrentFileCollectionFingerprint)outputsAfterExecution.get((Object)propertyName);
                FileCollectionFingerprint outputAfterPreviousExecution = OutputFilterUtil.getFingerprintForProperty((ImmutableSortedMap<String, FileCollectionFingerprint>)outputsAfterPreviousExecution, propertyName);
                return OutputFilterUtil.filterOutputFingerprint(outputAfterPreviousExecution, outputBeforeExecution, outputAfterExecution);
            }
        }));
    }

    private static FileCollectionFingerprint getFingerprintForProperty(@Nullable ImmutableSortedMap<String, FileCollectionFingerprint> fingerprinters, String propertyName) {
        FileCollectionFingerprint afterPreviousExecution;
        if (fingerprinters != null && (afterPreviousExecution = (FileCollectionFingerprint)fingerprinters.get((Object)propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionFingerprint.EMPTY;
    }

    @VisibleForTesting
    static CurrentFileCollectionFingerprint filterOutputFingerprint(@Nullable FileCollectionFingerprint afterPreviousExecution, CurrentFileCollectionFingerprint beforeExecution, CurrentFileCollectionFingerprint afterExecution) {
        CurrentFileCollectionFingerprint filesFingerprint;
        final Map<String, FileSystemLocationSnapshot> beforeExecutionSnapshots = OutputFilterUtil.getAllSnapshots(beforeExecution);
        if (!beforeExecution.getFingerprints().isEmpty() && !afterExecution.getFingerprints().isEmpty()) {
            Object afterPreviousFingerprints = afterPreviousExecution != null ? afterPreviousExecution.getFingerprints() : ImmutableMap.of();
            ArrayList<FileSystemSnapshot> newRoots = new ArrayList<FileSystemSnapshot>();
            MutableBoolean hasBeenFiltered = new MutableBoolean(false);
            afterExecution.accept(new FileSystemSnapshotVisitor((Map)afterPreviousFingerprints, hasBeenFiltered, newRoots){
                private MerkleDirectorySnapshotBuilder merkleBuilder;
                private boolean currentRootFiltered = false;
                private DirectorySnapshot currentRoot;
                final /* synthetic */ Map val$afterPreviousFingerprints;
                final /* synthetic */ MutableBoolean val$hasBeenFiltered;
                final /* synthetic */ List val$newRoots;
                {
                    this.val$afterPreviousFingerprints = map2;
                    this.val$hasBeenFiltered = mutableBoolean;
                    this.val$newRoots = list;
                }

                @Override
                public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                    if (this.merkleBuilder == null) {
                        this.merkleBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
                        this.currentRoot = directorySnapshot;
                        this.currentRootFiltered = false;
                    }
                    this.merkleBuilder.preVisitDirectory(directorySnapshot);
                    return true;
                }

                @Override
                public void visit(FileSystemLocationSnapshot fileSnapshot) {
                    if (!OutputFilterUtil.isOutputEntry(fileSnapshot, beforeExecutionSnapshots, this.val$afterPreviousFingerprints)) {
                        this.val$hasBeenFiltered.set(true);
                        this.currentRootFiltered = true;
                        return;
                    }
                    if (this.merkleBuilder == null) {
                        this.val$newRoots.add(fileSnapshot);
                    } else {
                        this.merkleBuilder.visit(fileSnapshot);
                    }
                }

                @Override
                public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                    boolean isOutputDir = OutputFilterUtil.isOutputEntry(directorySnapshot, beforeExecutionSnapshots, this.val$afterPreviousFingerprints);
                    boolean includedDir = this.merkleBuilder.postVisitDirectory(isOutputDir);
                    if (!includedDir) {
                        this.currentRootFiltered = true;
                        this.val$hasBeenFiltered.set(true);
                    }
                    if (this.merkleBuilder.isRoot()) {
                        FileSystemLocationSnapshot result = this.merkleBuilder.getResult();
                        if (result != null) {
                            this.val$newRoots.add(this.currentRootFiltered ? result : this.currentRoot);
                        }
                        this.merkleBuilder = null;
                        this.currentRoot = null;
                    }
                }
            });
            filesFingerprint = !hasBeenFiltered.get() ? afterExecution : DefaultCurrentFileCollectionFingerprint.from(newRoots, AbsolutePathFingerprintingStrategy.IGNORE_MISSING);
        } else {
            filesFingerprint = afterExecution;
        }
        return filesFingerprint;
    }

    private static Map<String, FileSystemLocationSnapshot> getAllSnapshots(CurrentFileCollectionFingerprint fingerprint) {
        GetAllSnapshotsVisitor afterExecutionVisitor = new GetAllSnapshotsVisitor();
        fingerprint.accept(afterExecutionVisitor);
        return afterExecutionVisitor.getSnapshots();
    }

    private static boolean isOutputEntry(FileSystemLocationSnapshot snapshot, Map<String, FileSystemLocationSnapshot> beforeSnapshots, Map<String, FileSystemLocationFingerprint> afterPreviousFingerprints) {
        if (snapshot.getType() == FileType.Missing) {
            return false;
        }
        FileSystemLocationSnapshot beforeSnapshot = beforeSnapshots.get(snapshot.getAbsolutePath());
        if (beforeSnapshot == null) {
            return true;
        }
        if (!snapshot.isContentAndMetadataUpToDate(beforeSnapshot)) {
            return true;
        }
        return afterPreviousFingerprints.containsKey(snapshot.getAbsolutePath());
    }

    private static class GetAllSnapshotsVisitor
    implements FileSystemSnapshotVisitor {
        private final Map<String, FileSystemLocationSnapshot> snapshots = new HashMap<String, FileSystemLocationSnapshot>();

        private GetAllSnapshotsVisitor() {
        }

        @Override
        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.snapshots.put(directorySnapshot.getAbsolutePath(), directorySnapshot);
            return true;
        }

        @Override
        public void visit(FileSystemLocationSnapshot fileSnapshot) {
            this.snapshots.put(fileSnapshot.getAbsolutePath(), fileSnapshot);
        }

        @Override
        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
        }

        public Map<String, FileSystemLocationSnapshot> getSnapshots() {
            return this.snapshots;
        }
    }
}

