/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.internal.execution.history.impl.SerializableFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.FingerprintMapSerializer;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

public class FileCollectionFingerprintSerializer
implements Serializer<FileCollectionFingerprint> {
    private final FingerprintMapSerializer fingerprintMapSerializer;
    private final StringInterner stringInterner;
    private final HashCodeSerializer hashCodeSerializer;

    public FileCollectionFingerprintSerializer(StringInterner stringInterner) {
        this.fingerprintMapSerializer = new FingerprintMapSerializer(stringInterner);
        this.stringInterner = stringInterner;
        this.hashCodeSerializer = new HashCodeSerializer();
    }

    @Override
    public FileCollectionFingerprint read(Decoder decoder) throws IOException {
        Object fingerprints = this.fingerprintMapSerializer.read(decoder);
        if (fingerprints.isEmpty()) {
            return FileCollectionFingerprint.EMPTY;
        }
        ImmutableMultimap<String, HashCode> rootHashes = this.readRootHashes(decoder);
        return new SerializableFileCollectionFingerprint((Map<String, FileSystemLocationFingerprint>)fingerprints, rootHashes);
    }

    private ImmutableMultimap<String, HashCode> readRootHashes(Decoder decoder) throws IOException {
        int numberOfRoots = decoder.readSmallInt();
        if (numberOfRoots == 0) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (int i = 0; i < numberOfRoots; ++i) {
            String absolutePath = this.stringInterner.intern(decoder.readString());
            HashCode rootHash = this.hashCodeSerializer.read(decoder);
            builder.put((Object)absolutePath, (Object)rootHash);
        }
        return builder.build();
    }

    @Override
    public void write(Encoder encoder, FileCollectionFingerprint value) throws Exception {
        this.fingerprintMapSerializer.write(encoder, value.getFingerprints());
        if (!value.getFingerprints().isEmpty()) {
            this.writeRootHashes(encoder, value.getRootHashes());
        }
    }

    private void writeRootHashes(Encoder encoder, ImmutableMultimap<String, HashCode> rootHashes) throws IOException {
        encoder.writeSmallInt(rootHashes.size());
        for (Map.Entry entry : rootHashes.entries()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.hashCodeSerializer.write(encoder, (HashCode)entry.getValue());
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FileCollectionFingerprintSerializer rhs = (FileCollectionFingerprintSerializer)obj;
        return Objects.equal((Object)this.fingerprintMapSerializer, (Object)rhs.fingerprintMapSerializer) && Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.fingerprintMapSerializer, this.hashCodeSerializer});
    }
}

