/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;

public class DefaultOutputFilesRepository
implements OutputFilesRepository,
Closeable {
    private final PersistentCache cacheAccess;
    private final PersistentIndexedCache<String, Boolean> outputFiles;

    public DefaultOutputFilesRepository(PersistentCache cacheAccess, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cacheAccess = cacheAccess;
        this.outputFiles = cacheAccess.createCache(DefaultOutputFilesRepository.cacheParameters(inMemoryCacheDecoratorFactory));
    }

    @Override
    public boolean isGeneratedByGradle(File file) {
        File absoluteFile = file.getAbsoluteFile();
        return this.containsFilesGeneratedByGradle(absoluteFile) || this.isContainedInAnOutput(absoluteFile);
    }

    private boolean isContainedInAnOutput(File absoluteFile) {
        for (File currentFile = absoluteFile; currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.outputFiles.get(currentFile.getPath()) != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    private boolean containsFilesGeneratedByGradle(File absoluteFile) {
        return this.outputFiles.get(absoluteFile.getPath()) != null;
    }

    @Override
    public void recordOutputs(Iterable<? extends FileSystemSnapshot> outputFileFingerprints) {
        for (FileSystemSnapshot fileSystemSnapshot : outputFileFingerprints) {
            fileSystemSnapshot.accept(new FileSystemSnapshotVisitor(){

                @Override
                public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                    this.recordOutputSnapshot(directorySnapshot);
                    return false;
                }

                @Override
                public void visit(FileSystemLocationSnapshot fileSnapshot) {
                    if (fileSnapshot.getType() == FileType.RegularFile) {
                        this.recordOutputSnapshot(fileSnapshot);
                    }
                }

                private void recordOutputSnapshot(FileSystemLocationSnapshot directorySnapshot) {
                    String outputFilePath = directorySnapshot.getAbsolutePath();
                    File outputFile = new File(outputFilePath);
                    DefaultOutputFilesRepository.this.outputFiles.put(outputFilePath, Boolean.TRUE);
                    for (File outputFileParent = outputFile.getParentFile(); outputFileParent != null; outputFileParent = outputFileParent.getParentFile()) {
                        String parentPath = outputFileParent.getPath();
                        if (DefaultOutputFilesRepository.this.outputFiles.get(parentPath) != null) break;
                        DefaultOutputFilesRepository.this.outputFiles.put(parentPath, Boolean.FALSE);
                    }
                }

                @Override
                public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                }
            });
        }
    }

    private static PersistentIndexedCacheParameters<String, Boolean> cacheParameters(InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        return PersistentIndexedCacheParameters.of("outputFiles", String.class, Boolean.class).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(100000, true));
    }

    @Override
    public void close() throws IOException {
        this.cacheAccess.close();
    }
}

