/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.internal.change.ChangeContainer;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.DescriptiveChange;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class ImplementationChanges
implements ChangeContainer {
    private final ImplementationSnapshot previousImplementation;
    private final ImmutableList<ImplementationSnapshot> previousAdditionalImplementations;
    private final ImplementationSnapshot currentImplementation;
    private final ImmutableList<ImplementationSnapshot> currentAdditionalImplementations;
    private final Describable executable;

    public ImplementationChanges(ImplementationSnapshot previousImplementation, ImmutableList<ImplementationSnapshot> previousAdditionalImplementations, ImplementationSnapshot currentImplementation, ImmutableList<ImplementationSnapshot> currentAdditionalImplementations, Describable executable) {
        this.previousImplementation = previousImplementation;
        this.previousAdditionalImplementations = previousAdditionalImplementations;
        this.currentImplementation = currentImplementation;
        this.currentAdditionalImplementations = currentAdditionalImplementations;
        this.executable = executable;
    }

    @Override
    public boolean accept(ChangeVisitor visitor) {
        if (!this.currentImplementation.getTypeName().equals(this.previousImplementation.getTypeName())) {
            return visitor.visitChange(new DescriptiveChange("The type of %s has changed from '%s' to '%s'.", this.executable.getDisplayName(), this.previousImplementation.getTypeName(), this.currentImplementation.getTypeName()));
        }
        if (this.currentImplementation.isUnknown()) {
            return visitor.visitChange(new DescriptiveChange("The type of %s %s", this.executable.getDisplayName(), this.currentImplementation.getUnknownReason()));
        }
        if (this.previousImplementation.isUnknown()) {
            return visitor.visitChange(new DescriptiveChange("During the previous execution of %s, it %s", this.executable.getDisplayName(), this.previousImplementation.getUnknownReason()));
        }
        if (!this.currentImplementation.getClassLoaderHash().equals(this.previousImplementation.getClassLoaderHash())) {
            return visitor.visitChange(new DescriptiveChange("Class path of %s has changed from %s to %s.", this.executable.getDisplayName(), this.previousImplementation.getClassLoaderHash(), this.currentImplementation.getClassLoaderHash()));
        }
        ImplementationSnapshot unknownImplementation = ImplementationChanges.findUnknownImplementation(this.currentAdditionalImplementations);
        if (unknownImplementation != null) {
            return visitor.visitChange(new DescriptiveChange("Additional action for %s: %s", this.executable.getDisplayName(), unknownImplementation.getUnknownReason()));
        }
        ImplementationSnapshot previousUnknownImplementation = ImplementationChanges.findUnknownImplementation(this.previousAdditionalImplementations);
        if (previousUnknownImplementation != null) {
            return visitor.visitChange(new DescriptiveChange("During the previous execution of %s, it had an additional action that %s", this.executable.getDisplayName(), previousUnknownImplementation.getUnknownReason()));
        }
        if (!this.currentAdditionalImplementations.equals(this.previousAdditionalImplementations)) {
            return visitor.visitChange(new DescriptiveChange("One or more additional actions for %s have changed.", this.executable.getDisplayName()));
        }
        return true;
    }

    @Nullable
    private static ImplementationSnapshot findUnknownImplementation(Iterable<ImplementationSnapshot> implementations) {
        for (ImplementationSnapshot implementation : implementations) {
            if (!implementation.isUnknown()) continue;
            return implementation;
        }
        return null;
    }
}

