/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import org.gradle.internal.change.ChangeContainer;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.execution.history.changes.PropertyDiffListener;
import org.gradle.internal.execution.history.changes.SortedMapDiffUtil;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public abstract class AbstractFingerprintChanges
implements ChangeContainer {
    protected final ImmutableSortedMap<String, FileCollectionFingerprint> previous;
    protected final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current;
    private final String title;

    protected AbstractFingerprintChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current, String title) {
        this.previous = previous;
        this.current = current;
        this.title = title;
    }

    protected boolean accept(final ChangeVisitor visitor, final boolean includeAdded) {
        return SortedMapDiffUtil.diff(this.previous, this.current, new PropertyDiffListener<String, FileCollectionFingerprint, CurrentFileCollectionFingerprint>(){

            @Override
            public boolean removed(String previousProperty) {
                return true;
            }

            @Override
            public boolean added(String currentProperty) {
                return true;
            }

            @Override
            public boolean updated(String property, FileCollectionFingerprint previousFingerprint, CurrentFileCollectionFingerprint currentFingerprint) {
                String propertyTitle = AbstractFingerprintChanges.this.title + " property '" + property + "'";
                return currentFingerprint.visitChangesSince(previousFingerprint, propertyTitle, includeAdded, visitor);
            }
        });
    }
}

