/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class RealisedMavenModuleResolveMetadata
extends AbstractRealisedModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    private final NamedObjectInstantiator objectInstantiator;
    private final ImmutableList<MavenDependencyDescriptor> dependencies;
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;
    private final ImmutableList<? extends ConfigurationMetadata> derivedVariants;

    public static RealisedMavenModuleResolveMetadata transform(DefaultMavenModuleResolveMetadata metadata) {
        Object maybeDeriveVariants;
        VariantMetadataRules variantMetadataRules = metadata.getVariantMetadataRules();
        ImmutableList<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> variants = LazyToRealisedModuleComponentResolveMetadataHelper.realiseVariants(metadata, variantMetadataRules, (ImmutableList<? extends ComponentVariant>)metadata.getVariants());
        HashMap configurations = Maps.newHashMapWithExpectedSize((int)metadata.getConfigurationNames().size());
        ImmutableList derivedVariants = ImmutableList.of();
        if (variants.isEmpty() && (maybeDeriveVariants = metadata.maybeDeriveVariants()).isPresent()) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (ConfigurationMetadata derivedVariant : (ImmutableList)maybeDeriveVariants.get()) {
                ImmutableList dependencies = (ImmutableList)Cast.uncheckedCast(derivedVariant.getDependencies());
                RealisedConfigurationMetadata derivedVariantMetadata = new RealisedConfigurationMetadata(metadata.getId(), derivedVariant.getName(), derivedVariant.isTransitive(), derivedVariant.isVisible(), derivedVariant.getHierarchy(), (ImmutableList<? extends ModuleComponentArtifactMetadata>)((ImmutableList)Cast.uncheckedCast(derivedVariant.getArtifacts())), derivedVariant.getExcludes(), derivedVariant.getAttributes(), (ImmutableCapabilities)derivedVariant.getCapabilities(), (ImmutableList<ModuleDependencyMetadata>)dependencies);
                builder.add((Object)derivedVariantMetadata);
            }
            derivedVariants = builder.build();
        }
        for (String configurationName : metadata.getConfigurationNames()) {
            ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
            Configuration configuration = (Configuration)configurationDefinitions.get((Object)configurationName);
            AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata variant = new AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata(configurationName);
            ImmutableAttributes variantAttributes = variantMetadataRules.applyVariantAttributeRules(variant, metadata.getAttributes());
            CapabilitiesMetadata capabilitiesMetadata = variantMetadataRules.applyCapabilitiesRules(variant, ImmutableCapabilities.EMPTY);
            List<? extends DependencyMetadata> dependencies = metadata.getConfiguration(configurationName).getDependencies();
            RealisedConfigurationMetadata realisedConfiguration = RealisedMavenModuleResolveMetadata.createConfiguration(metadata.getId(), configurationName, configuration.isTransitive(), configuration.isVisible(), LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions), dependencies, variantAttributes, ImmutableCapabilities.of(capabilitiesMetadata.getCapabilities()));
            configurations.put(configurationName, realisedConfiguration);
        }
        RealisedMavenModuleResolveMetadata realisedMavenModuleResolveMetadata = new RealisedMavenModuleResolveMetadata(metadata, variants, (List<ConfigurationMetadata>)derivedVariants, configurations);
        return realisedMavenModuleResolveMetadata;
    }

    private static RealisedConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, List<? extends DependencyMetadata> dependencies, ImmutableAttributes attributes, ImmutableCapabilities capabilities) {
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts = RealisedMavenModuleResolveMetadata.getArtifactsForConfiguration(componentId, name);
        ImmutableList asImmutable = ImmutableList.copyOf((Collection)((Collection)Cast.uncheckedCast(dependencies)));
        RealisedConfigurationMetadata configuration = new RealisedConfigurationMetadata(componentId, name, transitive, visible, hierarchy, artifacts, (ImmutableList<ExcludeMetadata>)ImmutableList.of(), attributes, capabilities, (ImmutableList<ModuleDependencyMetadata>)asImmutable);
        return configuration;
    }

    static ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactsForConfiguration(ModuleComponentIdentifier id, String name) {
        ImmutableList artifacts = name.equals("compile") || name.equals("runtime") || name.equals("default") || name.equals("test") ? ImmutableList.of((Object)new DefaultModuleComponentArtifactMetadata(id, new DefaultIvyArtifactName(id.getModule(), "jar", "jar"))) : ImmutableList.of();
        return artifacts;
    }

    private static ImmutableList<ModuleDependencyMetadata> filterDependencies(ModuleComponentIdentifier componentId, ConfigurationMetadata config, ImmutableList<MavenDependencyDescriptor> dependencies) {
        ImmutableList.Builder filteredDependencies = ImmutableList.builder();
        boolean isOptionalConfiguration = "optional".equals(config.getName());
        for (MavenDependencyDescriptor dependency : dependencies) {
            if (isOptionalConfiguration && RealisedMavenModuleResolveMetadata.includeInOptionalConfiguration(dependency)) {
                filteredDependencies.add((Object)new DefaultMavenModuleResolveMetadata.OptionalConfigurationDependencyMetadata(config, componentId, dependency));
                continue;
            }
            if (!RealisedMavenModuleResolveMetadata.include(dependency, config.getHierarchy())) continue;
            filteredDependencies.add((Object)RealisedMavenModuleResolveMetadata.contextualize(config, componentId, dependency));
        }
        return filteredDependencies.build();
    }

    static ModuleDependencyMetadata contextualize(ConfigurationMetadata config, ModuleComponentIdentifier componentId, MavenDependencyDescriptor incoming) {
        ConfigurationBoundExternalDependencyMetadata dependency = new ConfigurationBoundExternalDependencyMetadata(config, componentId, incoming);
        dependency.alwaysUseAttributeMatching();
        return dependency;
    }

    private static boolean includeInOptionalConfiguration(MavenDependencyDescriptor dependency) {
        MavenScope dependencyScope = dependency.getScope();
        return dependency.isOptional() && dependencyScope != MavenScope.Test && dependencyScope != MavenScope.System;
    }

    private static boolean include(MavenDependencyDescriptor dependency, Collection<String> hierarchy) {
        MavenScope dependencyScope = dependency.getScope();
        if (dependency.isOptional()) {
            return false;
        }
        return hierarchy.contains(dependencyScope.getLowerName());
    }

    RealisedMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ImmutableList<? extends ComponentVariant> variants, List<ConfigurationMetadata> derivedVariants, Map<String, ConfigurationMetadata> configurations) {
        super(metadata, variants, configurations);
        this.objectInstantiator = metadata.getObjectInstantiator();
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.dependencies = metadata.getDependencies();
        this.derivedVariants = ImmutableList.copyOf(derivedVariants);
    }

    private RealisedMavenModuleResolveMetadata(RealisedMavenModuleResolveMetadata metadata, ModuleSource source) {
        super(metadata, source);
        this.objectInstantiator = metadata.objectInstantiator;
        this.packaging = metadata.packaging;
        this.relocated = metadata.relocated;
        this.snapshotTimestamp = metadata.snapshotTimestamp;
        this.dependencies = metadata.dependencies;
        this.derivedVariants = metadata.derivedVariants;
    }

    @Override
    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        return Optional.of(this.getDerivedVariants());
    }

    ImmutableList<? extends ConfigurationMetadata> getDerivedVariants() {
        return this.derivedVariants;
    }

    @Override
    public RealisedMavenModuleResolveMetadata withSource(ModuleSource source) {
        return new RealisedMavenModuleResolveMetadata(this, source);
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return new DefaultMutableMavenModuleResolveMetadata(this, this.objectInstantiator);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public ImmutableList<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealisedMavenModuleResolveMetadata that = (RealisedMavenModuleResolveMetadata)o;
        return this.relocated == that.relocated && Objects.equal(this.dependencies, that.dependencies) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.snapshotTimestamp, (Object)that.snapshotTimestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.packaging, this.relocated, this.snapshotTimestamp});
    }
}

