/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.ivy;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

class IvyConfigurationHelper {
    private final ImmutableList<Artifact> artifactDefinitions;
    private final Map<Artifact, ModuleComponentArtifactMetadata> artifacts;
    private final ImmutableList<Exclude> excludes;
    private final ImmutableList<IvyDependencyDescriptor> dependencies;
    private final ModuleComponentIdentifier componentId;

    IvyConfigurationHelper(ImmutableList<Artifact> artifactDefinitions, Map<Artifact, ModuleComponentArtifactMetadata> artifacts, ImmutableList<Exclude> excludes, ImmutableList<IvyDependencyDescriptor> dependencies, ModuleComponentIdentifier componentId) {
        this.artifactDefinitions = artifactDefinitions;
        this.artifacts = artifacts;
        this.excludes = excludes;
        this.dependencies = dependencies;
        this.componentId = componentId;
    }

    ImmutableList<ModuleComponentArtifactMetadata> filterArtifacts(String name, Collection<String> hierarchy) {
        LinkedHashSet<ModuleComponentArtifactMetadata> artifacts = new LinkedHashSet<ModuleComponentArtifactMetadata>();
        this.collectArtifactsFor(name, artifacts);
        for (String parent : hierarchy) {
            this.collectArtifactsFor(parent, artifacts);
        }
        return ImmutableList.copyOf(artifacts);
    }

    private void collectArtifactsFor(String name, Collection<ModuleComponentArtifactMetadata> dest) {
        for (Artifact artifact : this.artifactDefinitions) {
            if (!artifact.getConfigurations().contains(name)) continue;
            ModuleComponentArtifactMetadata artifactMetadata = this.artifacts.get(artifact);
            if (artifactMetadata == null) {
                artifactMetadata = new DefaultModuleComponentArtifactMetadata(this.componentId, artifact.getArtifactName());
                this.artifacts.put(artifact, artifactMetadata);
            }
            dest.add(artifactMetadata);
        }
    }

    ImmutableList<ExcludeMetadata> filterExcludes(ImmutableSet<String> hierarchy) {
        ImmutableList.Builder filtered = ImmutableList.builder();
        block0: for (Exclude exclude : this.excludes) {
            for (String config : exclude.getConfigurations()) {
                if (!hierarchy.contains((Object)config)) continue;
                filtered.add((Object)exclude);
                continue block0;
            }
        }
        return filtered.build();
    }

    ImmutableList<ModuleDependencyMetadata> filterDependencies(ConfigurationMetadata config) {
        ImmutableList.Builder filteredDependencies = ImmutableList.builder();
        for (IvyDependencyDescriptor dependency : this.dependencies) {
            if (!this.include(dependency, config.getName(), (Collection<String>)config.getHierarchy())) continue;
            filteredDependencies.add((Object)this.contextualize(config, this.componentId, dependency));
        }
        return filteredDependencies.build();
    }

    ModuleDependencyMetadata contextualize(ConfigurationMetadata config, ModuleComponentIdentifier componentId, IvyDependencyDescriptor incoming) {
        return new ConfigurationBoundExternalDependencyMetadata(config, componentId, incoming);
    }

    private boolean include(IvyDependencyDescriptor dependency, String configName, Collection<String> hierarchy) {
        Set dependencyConfigurations = dependency.getConfMappings().keySet();
        for (String moduleConfiguration : dependencyConfigurations) {
            if (moduleConfiguration.equals("%") || hierarchy.contains(moduleConfiguration)) {
                return true;
            }
            if (!moduleConfiguration.equals("*")) continue;
            boolean include = true;
            for (String conf2 : dependencyConfigurations) {
                if (!conf2.startsWith("!") || !conf2.substring(1).equals(configName)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            return true;
        }
        return false;
    }
}

