/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;

public class PreferJavaRuntimeVariant
extends EmptySchema {
    private static final Usage RUNTIME_USAGE = NamedObjectInstantiator.INSTANCE.named(Usage.class, "java-runtime");
    private static final Set<Attribute<?>> SUPPORTED_ATTRIBUTES = Collections.singleton(Usage.USAGE_ATTRIBUTE);
    private static final PreferJavaRuntimeVariant SCHEMA_DEFAULT_JAVA_VARIANTS = new PreferJavaRuntimeVariant();

    static PreferJavaRuntimeVariant schema() {
        return SCHEMA_DEFAULT_JAVA_VARIANTS;
    }

    private PreferJavaRuntimeVariant() {
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return SUPPORTED_ATTRIBUTES;
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        if (Usage.USAGE_ATTRIBUTE.equals(attribute)) {
            return (DisambiguationRule)Cast.uncheckedCast(PreferRuntimeVariantUsageDisambiguationRule.INSTANCE);
        }
        return super.disambiguationRules(attribute);
    }

    private static class PreferRuntimeVariantUsageDisambiguationRule
    implements DisambiguationRule<Usage> {
        private static final PreferRuntimeVariantUsageDisambiguationRule INSTANCE = new PreferRuntimeVariantUsageDisambiguationRule();

        private PreferRuntimeVariantUsageDisambiguationRule() {
        }

        @Override
        public boolean doesSomething() {
            return true;
        }

        @Override
        public void execute(MultipleCandidatesResult<Usage> details) {
            Set candidates;
            if (details.getConsumerValue() == null && (candidates = details.getCandidateValues()).contains(RUNTIME_USAGE)) {
                details.closestMatch(RUNTIME_USAGE);
            }
        }
    }
}

