/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.AbstractConfigurationMetadata;
import org.gradle.internal.component.external.model.ForcedDependencyMetadataWrapper;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class DefaultConfigurationMetadata
extends AbstractConfigurationMetadata {
    private final VariantMetadataRules componentMetadataRules;
    private List<ModuleDependencyMetadata> calculatedDependencies;
    private final ImmutableAttributes componentLevelAttributes;
    private ImmutableAttributes computedAttributes;
    private CapabilitiesMetadata computedCapabilities;
    private final DependencyFilter dependencyFilter;
    private ImmutableList<ModuleDependencyMetadata> filteredConfigDependencies;

    public DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes componentLevelAttributes) {
        this(componentId, name, transitive, visible, hierarchy, artifacts, componentMetadataRules, excludes, componentLevelAttributes, (ImmutableList<ModuleDependencyMetadata>)((ImmutableList)null), DependencyFilter.ALL);
    }

    private DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes attributes, ImmutableList<ModuleDependencyMetadata> configDependencies, DependencyFilter dependencyFilter) {
        super(componentId, name, transitive, visible, artifacts, hierarchy, excludes, attributes, configDependencies, ImmutableCapabilities.EMPTY);
        this.componentMetadataRules = componentMetadataRules;
        this.componentLevelAttributes = attributes;
        this.dependencyFilter = dependencyFilter;
    }

    private DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes attributes, Factory<List<ModuleDependencyMetadata>> configDependenciesFactory, DependencyFilter dependencyFilter) {
        super(componentId, name, transitive, visible, artifacts, hierarchy, excludes, attributes, configDependenciesFactory, ImmutableCapabilities.EMPTY);
        this.componentMetadataRules = componentMetadataRules;
        this.componentLevelAttributes = attributes;
        this.dependencyFilter = dependencyFilter;
    }

    private DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes attributes, Factory<List<ModuleDependencyMetadata>> configDependenciesFactory, DependencyFilter dependencyFilter, List<Capability> capabilities) {
        super(componentId, name, transitive, visible, artifacts, hierarchy, excludes, attributes, configDependenciesFactory, ImmutableCapabilities.of(capabilities));
        this.componentMetadataRules = componentMetadataRules;
        this.componentLevelAttributes = attributes;
        this.dependencyFilter = dependencyFilter;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        if (this.computedAttributes == null) {
            this.computedAttributes = this.componentMetadataRules.applyVariantAttributeRules(this, super.getAttributes());
        }
        return this.computedAttributes;
    }

    @Override
    ImmutableList<ModuleDependencyMetadata> getConfigDependencies() {
        if (this.filteredConfigDependencies != null) {
            return this.filteredConfigDependencies;
        }
        ImmutableList<ModuleDependencyMetadata> filtered = super.getConfigDependencies();
        switch (this.dependencyFilter) {
            case CONSTRAINTS_ONLY: {
                filtered = this.withConstraints(true, filtered);
                break;
            }
            case DEPENDENCIES_ONLY: {
                filtered = this.withConstraints(false, filtered);
            }
        }
        switch (this.dependencyFilter) {
            case FORCED_ALL: 
            case FORCED_CONSTRAINTS_ONLY: 
            case FORCED_DEPENDENCIES_ONLY: {
                filtered = this.force(filtered);
            }
        }
        this.filteredConfigDependencies = filtered;
        return this.filteredConfigDependencies;
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        if (this.calculatedDependencies == null) {
            this.calculatedDependencies = this.componentMetadataRules.applyDependencyMetadataRules(this, this.getConfigDependencies());
        }
        return this.calculatedDependencies;
    }

    @Override
    public CapabilitiesMetadata getCapabilities() {
        if (this.computedCapabilities == null) {
            this.computedCapabilities = this.componentMetadataRules.applyCapabilitiesRules(this, super.getCapabilities());
        }
        return this.computedCapabilities;
    }

    @Override
    public DefaultConfigurationMetadata withAttributes(ImmutableAttributes attributes) {
        return new DefaultConfigurationMetadata(this.getComponentId(), this.getName(), this.isTransitive(), this.isVisible(), this.getHierarchy(), this.getArtifacts(), this.componentMetadataRules, this.getExcludes(), attributes, this.lazyConfigDependencies(), this.dependencyFilter);
    }

    public DefaultConfigurationMetadata withAttributes(String newName, ImmutableAttributes attributes) {
        return new DefaultConfigurationMetadata(this.getComponentId(), newName, this.isTransitive(), this.isVisible(), this.getHierarchy(), this.getArtifacts(), this.componentMetadataRules, this.getExcludes(), attributes, this.lazyConfigDependencies(), this.dependencyFilter);
    }

    public DefaultConfigurationMetadata withoutConstraints() {
        return new DefaultConfigurationMetadata(this.getComponentId(), this.getName(), this.isTransitive(), this.isVisible(), this.getHierarchy(), this.getArtifacts(), this.componentMetadataRules, this.getExcludes(), super.getAttributes(), this.lazyConfigDependencies(), this.dependencyFilter.dependenciesOnly());
    }

    public DefaultConfigurationMetadata withConstraintsOnly() {
        return new DefaultConfigurationMetadata(this.getComponentId(), this.getName(), this.isTransitive(), this.isVisible(), this.getHierarchy(), this.getArtifacts(), this.componentMetadataRules, this.getExcludes(), super.getAttributes(), this.lazyConfigDependencies(), this.dependencyFilter.constraintsOnly());
    }

    private Factory<List<ModuleDependencyMetadata>> lazyConfigDependencies() {
        return new Factory<List<ModuleDependencyMetadata>>(){

            @Override
            @Nullable
            public List<ModuleDependencyMetadata> create() {
                return DefaultConfigurationMetadata.super.getConfigDependencies();
            }
        };
    }

    public DefaultConfigurationMetadata withForcedDependencies() {
        return new DefaultConfigurationMetadata(this.getComponentId(), this.getName(), this.isTransitive(), this.isVisible(), this.getHierarchy(), this.getArtifacts(), this.componentMetadataRules, this.getExcludes(), this.componentLevelAttributes, this.lazyConfigDependencies(), this.dependencyFilter.forcing());
    }

    public DefaultConfigurationMetadata withCapabilities(List<Capability> capabilities) {
        return new DefaultConfigurationMetadata(this.getComponentId(), this.getName(), this.isTransitive(), this.isVisible(), this.getHierarchy(), this.getArtifacts(), this.componentMetadataRules, this.getExcludes(), super.getAttributes(), this.lazyConfigDependencies(), this.dependencyFilter, capabilities);
    }

    private ImmutableList<ModuleDependencyMetadata> force(ImmutableList<ModuleDependencyMetadata> configDependencies) {
        ImmutableList.Builder dependencies = new ImmutableList.Builder();
        for (ModuleDependencyMetadata configDependency : configDependencies) {
            if (configDependency instanceof ForcingDependencyMetadata) {
                dependencies.add((Object)((ModuleDependencyMetadata)((Object)((ForcingDependencyMetadata)((Object)configDependency)).forced())));
                continue;
            }
            dependencies.add((Object)new ForcedDependencyMetadataWrapper(configDependency));
        }
        return dependencies.build();
    }

    private ImmutableList<ModuleDependencyMetadata> withConstraints(boolean constraint, ImmutableList<ModuleDependencyMetadata> configDependencies) {
        if (configDependencies.isEmpty()) {
            return ImmutableList.of();
        }
        int count = 0;
        ImmutableList.Builder filtered = null;
        for (ModuleDependencyMetadata configDependency : configDependencies) {
            if (configDependency.isConstraint() != constraint) continue;
            if (filtered == null) {
                filtered = new ImmutableList.Builder();
            }
            filtered.add((Object)configDependency);
            ++count;
        }
        if (count == configDependencies.size()) {
            return configDependencies;
        }
        return filtered == null ? ImmutableList.of() : filtered.build();
    }

    private static enum DependencyFilter {
        ALL,
        CONSTRAINTS_ONLY,
        DEPENDENCIES_ONLY,
        FORCED_ALL,
        FORCED_CONSTRAINTS_ONLY,
        FORCED_DEPENDENCIES_ONLY;


        DependencyFilter forcing() {
            switch (this) {
                case ALL: {
                    return FORCED_ALL;
                }
                case CONSTRAINTS_ONLY: {
                    return FORCED_CONSTRAINTS_ONLY;
                }
                case DEPENDENCIES_ONLY: {
                    return FORCED_DEPENDENCIES_ONLY;
                }
            }
            return this;
        }

        DependencyFilter dependenciesOnly() {
            switch (this) {
                case ALL: {
                    return DEPENDENCIES_ONLY;
                }
                case FORCED_ALL: {
                    return FORCED_DEPENDENCIES_ONLY;
                }
                case DEPENDENCIES_ONLY: {
                    return this;
                }
            }
            throw new IllegalStateException("Cannot set dependencies only when constraints only has already been called");
        }

        DependencyFilter constraintsOnly() {
            switch (this) {
                case ALL: {
                    return CONSTRAINTS_ONLY;
                }
                case FORCED_ALL: {
                    return FORCED_CONSTRAINTS_ONLY;
                }
                case CONSTRAINTS_ONLY: {
                    return this;
                }
            }
            throw new IllegalStateException("Cannot set constraints only when dependencies only has already been called");
        }
    }
}

