/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

class AbstractVariantBackedConfigurationMetadata
implements ConfigurationMetadata {
    private final ModuleComponentIdentifier componentId;
    private final ComponentVariant variant;
    private final ImmutableList<GradleDependencyMetadata> dependencies;

    AbstractVariantBackedConfigurationMetadata(ModuleComponentIdentifier componentId, ComponentVariant variant) {
        this.componentId = componentId;
        this.variant = variant;
        ArrayList<GradleDependencyMetadata> dependencies = new ArrayList<GradleDependencyMetadata>(variant.getDependencies().size());
        boolean forcedDependencies = PlatformSupport.hasForcedDependencies(variant);
        for (ComponentVariant.Dependency dependency : variant.getDependencies()) {
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dependency.getGroup(), dependency.getModule()), dependency.getVersionConstraint(), dependency.getAttributes());
            ImmutableList<ExcludeMetadata> excludes = dependency.getExcludes();
            dependencies.add(new GradleDependencyMetadata(selector, (List<ExcludeMetadata>)excludes, false, dependency.getReason(), forcedDependencies));
        }
        for (ComponentVariant.DependencyConstraint dependencyConstraint : variant.getDependencyConstraints()) {
            dependencies.add(new GradleDependencyMetadata(DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dependencyConstraint.getGroup(), dependencyConstraint.getModule()), dependencyConstraint.getVersionConstraint(), dependencyConstraint.getAttributes()), Collections.emptyList(), true, dependencyConstraint.getReason(), forcedDependencies));
        }
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    AbstractVariantBackedConfigurationMetadata(ModuleComponentIdentifier componentId, ComponentVariant variant, ImmutableList<GradleDependencyMetadata> dependencies) {
        this.componentId = componentId;
        this.variant = variant;
        this.dependencies = dependencies;
    }

    @Override
    public String getName() {
        return this.variant.getName();
    }

    @Override
    public ImmutableSet<String> getHierarchy() {
        return ImmutableSet.of((Object)this.variant.getName());
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of(this.componentId, "variant", this.variant.getName());
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.variant.getAttributes().asImmutable();
    }

    @Override
    public Set<? extends VariantResolveMetadata> getVariants() {
        return ImmutableSet.of((Object)this.variant);
    }

    @Override
    public boolean isCanBeConsumed() {
        return true;
    }

    @Override
    public boolean isCanBeResolved() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        return ImmutableList.of();
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName artifact) {
        return new DefaultModuleComponentArtifactMetadata(this.componentId, artifact);
    }

    @Override
    public CapabilitiesMetadata getCapabilities() {
        return this.variant.getCapabilities();
    }

    @Override
    public List<? extends ComponentArtifactMetadata> getArtifacts() {
        return ImmutableList.of();
    }

    public List<? extends ModuleDependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    protected ComponentVariant getVariant() {
        return this.variant;
    }
}

