/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.DefaultSettings;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;

public class SettingsFactory {
    private final Instantiator instantiator;
    private final ServiceRegistryFactory serviceRegistryFactory;
    private final ScriptHandlerFactory scriptHandlerFactory;

    public SettingsFactory(Instantiator instantiator, ServiceRegistryFactory serviceRegistryFactory, ScriptHandlerFactory scriptHandlerFactory) {
        this.instantiator = instantiator;
        this.serviceRegistryFactory = serviceRegistryFactory;
        this.scriptHandlerFactory = scriptHandlerFactory;
    }

    public SettingsInternal createSettings(GradleInternal gradle, File settingsDir, ScriptSource settingsScript, Map<String, String> gradleProperties, StartParameter startParameter, ClassLoaderScope buildRootClassLoaderScope) {
        ClassLoaderScope settingsClassLoaderScope = buildRootClassLoaderScope.createChild("settings");
        ScriptHandlerInternal settingsScriptHandler = this.scriptHandlerFactory.create(settingsScript, settingsClassLoaderScope);
        DefaultSettings settings = this.instantiator.newInstance(DefaultSettings.class, this.serviceRegistryFactory, gradle, settingsClassLoaderScope, buildRootClassLoaderScope, settingsScriptHandler, settingsDir, settingsScript, startParameter);
        DynamicObject dynamicObject = ((DynamicObjectAware)((Object)settings)).getAsDynamicObject();
        ((ExtensibleDynamicObject)dynamicObject).addProperties(gradleProperties);
        return settings;
    }
}

