/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.gradle.internal.reflect.PropertyMutator;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPropertySettingBuildLoader
implements BuildLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectPropertySettingBuildLoader.class);
    private final IGradlePropertiesLoader propertiesLoader;
    private final BuildLoader buildLoader;

    public ProjectPropertySettingBuildLoader(IGradlePropertiesLoader propertiesLoader, BuildLoader buildLoader) {
        this.buildLoader = buildLoader;
        this.propertiesLoader = propertiesLoader;
    }

    @Override
    public void load(SettingsInternal settings, GradleInternal gradle) {
        this.buildLoader.load(settings, gradle);
        this.setProjectProperties(gradle.getRootProject(), new CachingPropertyApplicator());
    }

    private void setProjectProperties(Project project, CachingPropertyApplicator applicator) {
        this.addPropertiesToProject(project, applicator);
        for (Project childProject : project.getChildProjects().values()) {
            this.setProjectProperties(childProject, applicator);
        }
    }

    private void addPropertiesToProject(Project project, CachingPropertyApplicator applicator) {
        Properties projectProperties = new Properties();
        File projectPropertiesFile = new File(project.getProjectDir(), "gradle.properties");
        LOGGER.debug("Looking for project properties from: {}", (Object)projectPropertiesFile);
        if (projectPropertiesFile.isFile()) {
            projectProperties = GUtil.loadProperties(projectPropertiesFile);
            LOGGER.debug("Adding project properties (if not overwritten by user properties): {}", projectProperties.keySet());
        } else {
            LOGGER.debug("project property file does not exists. We continue!");
        }
        Map<String, String> mergedProperties = this.propertiesLoader.mergeProperties(new HashMap<Object, Object>(projectProperties));
        for (Map.Entry<String, String> entry : mergedProperties.entrySet()) {
            applicator.configureProperty(project, entry.getKey(), entry.getValue());
        }
    }

    private static class CachingPropertyApplicator {
        private final Map<Pair<String, ? extends Class<?>>, PropertyMutator> mutators = Maps.newHashMap();
        private Class<? extends Project> projectClazz;

        private CachingPropertyApplicator() {
        }

        void configureProperty(Project project, String name, Object value) {
            Class<?> valueType;
            Pair<String, Class<?>> key;
            PropertyMutator propertyMutator;
            Class<?> clazz = project.getClass();
            if (clazz != this.projectClazz) {
                this.mutators.clear();
                this.projectClazz = clazz;
            }
            if ((propertyMutator = this.mutators.get(key = Pair.of(name, valueType = value == null ? null : value.getClass()))) != null) {
                propertyMutator.setValue(project, value);
            } else {
                if (!this.mutators.containsKey(key)) {
                    propertyMutator = JavaPropertyReflectionUtil.writeablePropertyIfExists(clazz, name, valueType);
                    this.mutators.put(key, propertyMutator);
                    if (propertyMutator != null) {
                        propertyMutator.setValue(project, value);
                        return;
                    }
                }
                ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
                extraProperties.set(name, value);
            }
        }
    }
}

