/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.ConfigureBuildBuildOperationType;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.LoadBuildBuildOperationType;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.NotifyProjectsEvaluatedBuildOperationType;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Collections2;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;

public class DefaultGradleLauncher
implements GradleLauncher {
    private static final ConfigureBuildBuildOperationType.Result CONFIGURE_BUILD_RESULT = new ConfigureBuildBuildOperationType.Result(){};
    private static final NotifyProjectsEvaluatedBuildOperationType.Result PROJECTS_EVALUATED_RESULT = new NotifyProjectsEvaluatedBuildOperationType.Result(){};
    private static final LoadBuildBuildOperationType.Result RESULT = new LoadBuildBuildOperationType.Result(){};
    private final InitScriptHandler initScriptHandler;
    private final SettingsLoader settingsLoader;
    private final BuildLoader buildLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final ModelConfigurationListener modelConfigurationListener;
    private final BuildCompletionListener buildCompletionListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildConfigurationActionExecuter buildConfigurationActionExecuter;
    private final BuildExecuter buildExecuter;
    private final BuildScopeServices buildServices;
    private final List<?> servicesToStop;
    private final IncludedBuildControllers includedBuildControllers;
    private final PublicBuildPath fromBuild;
    private final GradleInternal gradle;
    private SettingsInternal settings;
    private Stage stage;

    public DefaultGradleLauncher(GradleInternal gradle, InitScriptHandler initScriptHandler, SettingsLoader settingsLoader, BuildLoader buildLoader, BuildConfigurer buildConfigurer, ExceptionAnalyser exceptionAnalyser, BuildListener buildListener, ModelConfigurationListener modelConfigurationListener, BuildCompletionListener buildCompletionListener, BuildOperationExecutor operationExecutor, BuildConfigurationActionExecuter buildConfigurationActionExecuter, BuildExecuter buildExecuter, BuildScopeServices buildServices, List<?> servicesToStop, IncludedBuildControllers includedBuildControllers, PublicBuildPath fromBuild) {
        this.gradle = gradle;
        this.initScriptHandler = initScriptHandler;
        this.settingsLoader = settingsLoader;
        this.buildLoader = buildLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = operationExecutor;
        this.buildConfigurationActionExecuter = buildConfigurationActionExecuter;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildServices = buildServices;
        this.servicesToStop = servicesToStop;
        this.includedBuildControllers = includedBuildControllers;
        this.fromBuild = fromBuild;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        this.doBuildStages(Stage.LoadSettings);
        return this.settings;
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        this.doBuildStages(Stage.Configure);
        return this.gradle;
    }

    @Override
    public GradleInternal executeTasks() {
        this.doBuildStages(Stage.RunTasks);
        return this.gradle;
    }

    @Override
    public void finishBuild() {
        if (this.stage != null) {
            this.finishBuild(this.stage.getDisplayName(), null);
        }
    }

    private void doBuildStages(Stage upTo) {
        try {
            this.loadSettings();
            if (upTo == Stage.LoadSettings) {
                return;
            }
            this.configureBuild();
            if (upTo == Stage.Configure) {
                return;
            }
            this.constructTaskGraph();
            if (upTo == Stage.TaskGraph) {
                return;
            }
            this.runTasks();
            if (upTo == Stage.RunTasks) {
                return;
            }
            this.finishBuild();
        }
        catch (Throwable t) {
            this.finishBuild(upTo.getDisplayName(), t);
        }
    }

    private void finishBuild(String action, @Nullable Throwable stageFailure) {
        if (this.stage == Stage.Finished) {
            return;
        }
        RuntimeException reportableFailure = stageFailure == null ? null : this.exceptionAnalyser.transform(stageFailure);
        BuildResult buildResult = new BuildResult(action, this.gradle, reportableFailure);
        ArrayList<? extends Throwable> failures = new ArrayList<Throwable>();
        this.includedBuildControllers.finishBuild(failures);
        try {
            this.buildListener.buildFinished(buildResult);
        }
        catch (Throwable t) {
            failures.add(t);
        }
        this.stage = Stage.Finished;
        if (failures.isEmpty() && reportableFailure != null) {
            throw reportableFailure;
        }
        if (!failures.isEmpty()) {
            if (stageFailure instanceof MultipleBuildFailures) {
                failures.addAll(0, ((MultipleBuildFailures)stageFailure).getCauses());
            } else if (stageFailure != null) {
                failures.add(0, stageFailure);
            }
            throw this.exceptionAnalyser.transform(new MultipleBuildFailures(failures));
        }
    }

    private void loadSettings() {
        if (this.stage == null) {
            this.buildListener.buildStarted(this.gradle);
            this.buildOperationExecutor.run(new LoadBuild());
            this.stage = Stage.LoadSettings;
        }
    }

    private void configureBuild() {
        if (this.stage == Stage.LoadSettings) {
            this.buildOperationExecutor.run(new ConfigureBuild());
            this.stage = Stage.Configure;
        }
    }

    private void constructTaskGraph() {
        if (this.stage == Stage.Configure) {
            this.buildOperationExecutor.run(new CalculateTaskGraph());
            this.stage = Stage.TaskGraph;
        }
    }

    @Override
    public void scheduleTasks(Iterable<String> taskPaths) {
        GradleInternal gradle = this.getConfiguredBuild();
        LinkedHashSet allTasks = Sets.newLinkedHashSet(gradle.getStartParameter().getTaskNames());
        boolean added = allTasks.addAll(Lists.newArrayList(taskPaths));
        if (!added) {
            return;
        }
        gradle.getStartParameter().setTaskNames(allTasks);
        this.stage = Stage.Configure;
        this.doBuildStages(Stage.TaskGraph);
    }

    private void runTasks() {
        if (this.stage != Stage.TaskGraph) {
            throw new IllegalStateException("Cannot execute tasks: current stage = " + (Object)((Object)this.stage));
        }
        this.buildOperationExecutor.run(new ExecuteTasks());
        this.stage = Stage.RunTasks;
    }

    @Override
    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    @Override
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.buildServices).add(this.servicesToStop).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    private boolean isConfigureOnDemand() {
        return this.gradle.getStartParameter().isConfigureOnDemand();
    }

    private void projectsEvaluated() {
        this.buildOperationExecutor.run(new NotifyProjectsEvaluatedListeners());
    }

    private class NotifyProjectsEvaluatedListeners
    implements RunnableBuildOperation {
        private NotifyProjectsEvaluatedListeners() {
        }

        @Override
        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.buildListener.projectsEvaluated(DefaultGradleLauncher.this.gradle);
            context.setResult(PROJECTS_EVALUATED_RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName(DefaultGradleLauncher.this.gradle.contextualize("Notify projectsEvaluated listeners")).details(new NotifyProjectsEvaluatedBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return DefaultGradleLauncher.this.gradle.getIdentityPath().toString();
                }
            });
        }
    }

    private class ExecuteTasks
    implements RunnableBuildOperation {
        private ExecuteTasks() {
        }

        @Override
        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.includedBuildControllers.startTaskExecution();
            ArrayList taskFailures = new ArrayList();
            DefaultGradleLauncher.this.buildExecuter.execute(DefaultGradleLauncher.this.gradle, taskFailures);
            DefaultGradleLauncher.this.includedBuildControllers.awaitTaskCompletion(taskFailures);
            if (!taskFailures.isEmpty()) {
                throw new MultipleBuildFailures(taskFailures);
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            BuildOperationDescriptor.Builder builder = BuildOperationDescriptor.displayName(DefaultGradleLauncher.this.gradle.contextualize("Run tasks"));
            if (DefaultGradleLauncher.this.gradle.getParent() == null) {
                builder.operationType(BuildOperationCategory.RUN_WORK_ROOT_BUILD);
            } else {
                builder.operationType(BuildOperationCategory.RUN_WORK);
            }
            builder.totalProgress(DefaultGradleLauncher.this.gradle.getTaskGraph().size());
            return builder;
        }
    }

    private class CalculateTaskGraph
    implements RunnableBuildOperation {
        private CalculateTaskGraph() {
        }

        @Override
        public void run(BuildOperationContext buildOperationContext) {
            DefaultGradleLauncher.this.buildConfigurationActionExecuter.select(DefaultGradleLauncher.this.gradle);
            if (DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
            final TaskExecutionGraphInternal taskGraph = DefaultGradleLauncher.this.gradle.getTaskGraph();
            taskGraph.populate();
            DefaultGradleLauncher.this.includedBuildControllers.populateTaskGraphs();
            buildOperationContext.setResult(new CalculateTaskGraphBuildOperationType.Result(){

                @Override
                public List<String> getRequestedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getRequestedTasks());
                }

                @Override
                public List<String> getExcludedTaskPaths() {
                    return this.toTaskPaths(taskGraph.getFilteredTasks());
                }

                private List<String> toTaskPaths(Set<Task> tasks) {
                    return ImmutableSortedSet.copyOf((Collection)Collections2.transform(tasks, (Function)new Function<Task, String>(){

                        public String apply(Task task) {
                            return task.getPath();
                        }
                    })).asList();
                }
            });
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName(DefaultGradleLauncher.this.gradle.contextualize("Calculate task graph")).details(new CalculateTaskGraphBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return DefaultGradleLauncher.this.getGradle().getIdentityPath().getPath();
                }
            });
        }
    }

    private class ConfigureBuild
    implements RunnableBuildOperation {
        private ConfigureBuild() {
        }

        @Override
        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.buildLoader.load(DefaultGradleLauncher.this.settings, DefaultGradleLauncher.this.gradle);
            DefaultGradleLauncher.this.buildConfigurer.configure(DefaultGradleLauncher.this.gradle);
            if (!DefaultGradleLauncher.this.isConfigureOnDemand()) {
                DefaultGradleLauncher.this.projectsEvaluated();
            }
            DefaultGradleLauncher.this.modelConfigurationListener.onConfigure(DefaultGradleLauncher.this.gradle);
            context.setResult(CONFIGURE_BUILD_RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            BuildOperationDescriptor.Builder builder = BuildOperationDescriptor.displayName(DefaultGradleLauncher.this.gradle.contextualize("Configure build"));
            if (DefaultGradleLauncher.this.gradle.getParent() == null) {
                builder.operationType(BuildOperationCategory.CONFIGURE_ROOT_BUILD);
            } else {
                builder.operationType(BuildOperationCategory.CONFIGURE_BUILD);
            }
            builder.totalProgress(DefaultGradleLauncher.this.settings.getProjectRegistry().size());
            return builder.details(new ConfigureBuildBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return DefaultGradleLauncher.this.getGradle().getIdentityPath().toString();
                }
            });
        }
    }

    private class LoadBuild
    implements RunnableBuildOperation {
        private LoadBuild() {
        }

        @Override
        public void run(BuildOperationContext context) {
            DefaultGradleLauncher.this.initScriptHandler.executeScripts(DefaultGradleLauncher.this.gradle);
            DefaultGradleLauncher.this.settings = DefaultGradleLauncher.this.settingsLoader.findAndLoadSettings(DefaultGradleLauncher.this.gradle);
            context.setResult(RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName(DefaultGradleLauncher.this.gradle.contextualize("Load build")).details(new LoadBuildBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return DefaultGradleLauncher.this.gradle.getIdentityPath().toString();
                }

                @Override
                public String getIncludedBy() {
                    return DefaultGradleLauncher.this.fromBuild == null ? null : DefaultGradleLauncher.this.fromBuild.getBuildPath().toString();
                }
            });
        }
    }

    private static enum Stage {
        LoadSettings,
        Configure,
        TaskGraph,
        RunTasks{

            @Override
            String getDisplayName() {
                return "Build";
            }
        }
        ,
        Finished;


        String getDisplayName() {
            return this.name();
        }
    }
}

