/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.Script;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.configuration.ImportsReader;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.GradleResolveVisitor;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ImplementationHashAware;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptCompilationHandler
implements ScriptCompilationHandler {
    private Logger logger = LoggerFactory.getLogger(DefaultScriptCompilationHandler.class);
    private static final NoOpGroovyResourceLoader NO_OP_GROOVY_RESOURCE_LOADER = new NoOpGroovyResourceLoader();
    private static final String METADATA_FILE_NAME = "metadata.bin";
    private static final int EMPTY_FLAG = 1;
    private static final int HAS_METHODS_FLAG = 2;
    private final ClassLoaderCache classLoaderCache;
    private final Map<String, List<String>> simpleNameToFQN;

    public DefaultScriptCompilationHandler(ClassLoaderCache classLoaderCache, ImportsReader importsReader) {
        this.classLoaderCache = classLoaderCache;
        this.simpleNameToFQN = importsReader.getSimpleNameToFullClassNamesMapping();
    }

    @Override
    public void compileToDir(ScriptSource source, ClassLoader classLoader, File classesDir, File metadataDir, CompileOperation<?> extractingTransformer, Class<? extends Script> scriptBaseClass, Action<? super ClassNode> verifier) {
        Timer clock = Time.startTimer();
        GFileUtils.deleteDirectory(classesDir);
        GFileUtils.mkdirs(classesDir);
        CompilerConfiguration configuration = this.createBaseCompilerConfiguration(scriptBaseClass);
        configuration.setTargetDirectory(classesDir);
        try {
            this.compileScript(source, classLoader, configuration, metadataDir, extractingTransformer, verifier);
        }
        catch (GradleException e) {
            GFileUtils.deleteDirectory(classesDir);
            GFileUtils.deleteDirectory(metadataDir);
            throw e;
        }
        this.logger.debug("Timing: Writing script to cache at {} took: {}", (Object)classesDir.getAbsolutePath(), (Object)clock.getElapsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileScript(ScriptSource source, ClassLoader classLoader, CompilerConfiguration configuration, File metadataDir, CompileOperation<?> extractingTransformer, final Action<? super ClassNode> customVerifier) {
        final Transformer transformer = extractingTransformer != null ? extractingTransformer.getTransformer() : null;
        this.logger.info("Compiling {} using {}.", (Object)source.getDisplayName(), (Object)(transformer != null ? transformer.getClass().getSimpleName() : "no transformer"));
        final EmptyScriptDetector emptyScriptDetector = new EmptyScriptDetector();
        final PackageStatementDetector packageDetector = new PackageStatementDetector();
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader, configuration, false){

            protected CompilationUnit createCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource) {
                CustomCompilationUnit compilationUnit = new CustomCompilationUnit(compilerConfiguration, codeSource, customVerifier, this);
                if (transformer != null) {
                    transformer.register(compilationUnit);
                }
                compilationUnit.addPhaseOperation(packageDetector, 5);
                compilationUnit.addPhaseOperation(emptyScriptDetector, 5);
                return compilationUnit;
            }
        };
        groovyClassLoader.setResourceLoader((GroovyResourceLoader)NO_OP_GROOVY_RESOURCE_LOADER);
        String scriptText = source.getResource().getText();
        String scriptName = source.getClassName();
        GroovyCodeSource codeSource = new GroovyCodeSource(scriptText == null ? "" : scriptText, scriptName, "/groovy/script");
        try {
            try {
                groovyClassLoader.parseClass(codeSource, false);
            }
            catch (MultipleCompilationErrorsException e) {
                this.wrapCompilationFailure(source, e);
            }
            catch (CompilationFailedException e) {
                throw new GradleException(String.format("Could not compile %s.", source.getDisplayName()), e);
            }
            if (packageDetector.hasPackageStatement) {
                throw new UnsupportedOperationException(String.format("%s should not contain a package statement.", StringUtils.capitalize((String)source.getDisplayName())));
            }
            this.serializeMetadata(source, extractingTransformer, metadataDir, emptyScriptDetector.isEmptyScript(), emptyScriptDetector.getHasMethods());
        }
        finally {
            ClassLoaderUtils.tryClose((ClassLoader)groovyClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M> void serializeMetadata(ScriptSource scriptSource, CompileOperation<M> extractingTransformer, File metadataDir, boolean emptyScript, boolean hasMethods) {
        File metadataFile = new File(metadataDir, METADATA_FILE_NAME);
        try {
            GFileUtils.mkdirs(metadataDir);
            KryoBackedEncoder encoder = new KryoBackedEncoder(new FileOutputStream(metadataFile));
            try {
                byte flags = (byte)((emptyScript ? 1 : 0) | (hasMethods ? 2 : 0));
                encoder.writeByte(flags);
                if (extractingTransformer != null && extractingTransformer.getDataSerializer() != null) {
                    Serializer<M> serializer = extractingTransformer.getDataSerializer();
                    serializer.write(encoder, extractingTransformer.getExtractedData());
                }
            }
            finally {
                encoder.close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Failed to serialize script metadata extracted for %s", scriptSource.getDisplayName()), e);
        }
    }

    private void wrapCompilationFailure(ScriptSource source, MultipleCompilationErrorsException e) {
        for (Object message : e.getErrorCollector().getErrors()) {
            if (!(message instanceof SyntaxErrorMessage)) continue;
            try {
                SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)message;
                Field sourceField = SyntaxErrorMessage.class.getDeclaredField("source");
                sourceField.setAccessible(true);
                SourceUnit sourceUnit = (SourceUnit)sourceField.get(syntaxErrorMessage);
                Field nameField = SourceUnit.class.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(sourceUnit, source.getDisplayName());
            }
            catch (Exception failure) {
                throw UncheckedException.throwAsUncheckedException(failure);
            }
        }
        SyntaxException syntaxError = e.getErrorCollector().getSyntaxError(0);
        Integer lineNumber = syntaxError == null ? null : Integer.valueOf(syntaxError.getLine());
        throw new ScriptCompilationException(String.format("Could not compile %s.", source.getDisplayName()), (Throwable)e, source, lineNumber);
    }

    private CompilerConfiguration createBaseCompilerConfiguration(Class<? extends Script> scriptBaseClass) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setScriptBaseClass(scriptBaseClass.getName());
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Script, M> CompiledScript<T, M> loadFromDir(ScriptSource source, HashCode sourceHashCode, ClassLoader classLoader, File scriptCacheDir, File metadataCacheDir, CompileOperation<M> transformer, Class<T> scriptBaseClass, ClassLoaderId classLoaderId) {
        ClassesDirCompiledScript<T, Object> classesDirCompiledScript;
        File metadataFile = new File(metadataCacheDir, METADATA_FILE_NAME);
        KryoBackedDecoder decoder = new KryoBackedDecoder(new FileInputStream(metadataFile));
        try {
            boolean hasMethods;
            byte flags = decoder.readByte();
            boolean isEmpty = (flags & 1) != 0;
            boolean bl = hasMethods = (flags & 2) != 0;
            if (isEmpty) {
                this.classLoaderCache.remove(classLoaderId);
            }
            Object data = transformer != null && transformer.getDataSerializer() != null ? (Object)transformer.getDataSerializer().read(decoder) : null;
            classesDirCompiledScript = new ClassesDirCompiledScript<T, Object>(isEmpty, hasMethods, classLoaderId, scriptBaseClass, scriptCacheDir, classLoader, source, sourceHashCode, data);
        }
        catch (Throwable throwable) {
            try {
                decoder.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to deserialize script metadata extracted for %s", source.getDisplayName()), e);
            }
        }
        decoder.close();
        return classesDirCompiledScript;
    }

    private static class ScriptClassLoader
    extends VisitableURLClassLoader
    implements ImplementationHashAware {
        private final ScriptSource scriptSource;
        private final HashCode implementationHash;

        ScriptClassLoader(ScriptSource scriptSource, ClassLoader parent, ClassPath classPath, HashCode implementationHash) {
            super("groovy-script-" + scriptSource.getFileName() + "-loader", parent, classPath);
            this.scriptSource = scriptSource;
            this.implementationHash = implementationHash;
        }

        @Override
        public HashCode getImplementationHash() {
            return this.implementationHash;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith(this.scriptSource.getClassName())) {
                Class<?> cl = this.findLoadedClass(name);
                if (cl == null) {
                    cl = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(cl);
                }
                return cl;
            }
            return super.loadClass(name, resolve);
        }
    }

    private class ClassesDirCompiledScript<T extends Script, M>
    implements CompiledScript<T, M> {
        private final boolean isEmpty;
        private final boolean hasMethods;
        private final ClassLoaderId classLoaderId;
        private final Class<T> scriptBaseClass;
        private final File scriptCacheDir;
        private final ClassLoader classLoader;
        private final ScriptSource source;
        private final HashCode sourceHashCode;
        private final M metadata;
        private Class<? extends T> scriptClass;

        public ClassesDirCompiledScript(boolean isEmpty, boolean hasMethods, ClassLoaderId classLoaderId, Class<T> scriptBaseClass, File scriptCacheDir, ClassLoader classLoader, ScriptSource source, HashCode sourceHashCode, M metadata) {
            this.isEmpty = isEmpty;
            this.hasMethods = hasMethods;
            this.classLoaderId = classLoaderId;
            this.scriptBaseClass = scriptBaseClass;
            this.scriptCacheDir = scriptCacheDir;
            this.classLoader = classLoader;
            this.source = source;
            this.sourceHashCode = sourceHashCode;
            this.metadata = metadata;
        }

        @Override
        public boolean getRunDoesSomething() {
            return !this.isEmpty;
        }

        @Override
        public boolean getHasMethods() {
            return this.hasMethods;
        }

        @Override
        public M getData() {
            return this.metadata;
        }

        @Override
        public Class<? extends T> loadClass() {
            if (this.scriptClass == null) {
                if (this.isEmpty && !this.hasMethods) {
                    throw new UnsupportedOperationException("Cannot load script that does nothing.");
                }
                try {
                    ScriptClassLoader loader = DefaultScriptCompilationHandler.this.classLoaderCache.put(this.classLoaderId, new ScriptClassLoader(this.source, this.classLoader, DefaultClassPath.of(this.scriptCacheDir), this.sourceHashCode));
                    this.scriptClass = loader.loadClass(this.source.getClassName()).asSubclass(this.scriptBaseClass);
                }
                catch (Exception e) {
                    File expectedClassFile = new File(this.scriptCacheDir, this.source.getClassName() + ".class");
                    if (!expectedClassFile.exists()) {
                        throw new GradleException(String.format("Could not load compiled classes for %s from cache. Expected class file %s does not exist.", this.source.getDisplayName(), expectedClassFile.getAbsolutePath()), e);
                    }
                    throw new GradleException(String.format("Could not load compiled classes for %s from cache.", this.source.getDisplayName()), e);
                }
            }
            return this.scriptClass;
        }
    }

    private class CustomCompilationUnit
    extends CompilationUnit {
        public CustomCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource, final Action<? super ClassNode> customVerifier, GroovyClassLoader groovyClassLoader) {
            super(compilerConfiguration, codeSource, groovyClassLoader);
            this.verifier = new Verifier(){

                public void visitClass(ClassNode node) {
                    customVerifier.execute(node);
                    super.visitClass(node);
                }
            };
            this.resolveVisitor = new GradleResolveVisitor(this, DefaultScriptCompilationHandler.this.simpleNameToFQN);
        }
    }

    private static class NoOpGroovyResourceLoader
    implements GroovyResourceLoader {
        private NoOpGroovyResourceLoader() {
        }

        public URL loadGroovySource(String filename) throws MalformedURLException {
            return null;
        }
    }

    private static class EmptyScriptDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean emptyScript;
        private boolean hasMethods;

        private EmptyScriptDetector() {
        }

        public void call(SourceUnit source) {
            if (!source.getAST().getMethods().isEmpty()) {
                this.hasMethods = true;
            }
            this.emptyScript = this.isEmpty(source);
        }

        private boolean isEmpty(SourceUnit source) {
            List statements = source.getAST().getStatementBlock().getStatements();
            for (Statement statement : statements) {
                if (!AstUtils.mayHaveAnEffect(statement)) continue;
                return false;
            }
            return true;
        }

        public boolean getHasMethods() {
            return this.hasMethods;
        }

        public boolean isEmptyScript() {
            return this.emptyScript;
        }
    }

    private static class PackageStatementDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean hasPackageStatement;

        private PackageStatementDetector() {
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            this.hasPackageStatement = source.getAST().getPackageName() != null;
        }
    }
}

