/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskState;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.execution.ProjectExecutionServiceRegistry;
import org.gradle.execution.plan.DefaultExecutionPlan;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeExecutor;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.execution.taskgraph.NotifyTaskGraphWhenReadyBuildOperationType;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultTaskExecutionGraph
implements TaskExecutionGraphInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskExecutionGraph.class);
    private final PlanExecutor planExecutor;
    private final ResourceLockCoordinationService coordinationService;
    private final List<NodeExecutor> nodeExecutors;
    private final GradleInternal gradleInternal;
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final DefaultExecutionPlan executionPlan;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ListenerBuildOperationDecorator listenerBuildOperationDecorator;
    private GraphState graphState = GraphState.EMPTY;
    private List<Task> allTasks;
    private boolean hasFiredWhenReady;
    private final Set<Task> requestedTasks = Sets.newTreeSet();

    public DefaultTaskExecutionGraph(PlanExecutor planExecutor, List<NodeExecutor> nodeExecutors, BuildOperationExecutor buildOperationExecutor, ListenerBuildOperationDecorator listenerBuildOperationDecorator, WorkerLeaseService workerLeaseService, ResourceLockCoordinationService coordinationService, GradleInternal gradleInternal, TaskNodeFactory taskNodeFactory, TaskDependencyResolver dependencyResolver, ListenerBroadcast<TaskExecutionGraphListener> graphListeners, ListenerBroadcast<TaskExecutionListener> taskListeners) {
        this.planExecutor = planExecutor;
        this.nodeExecutors = nodeExecutors;
        this.buildOperationExecutor = buildOperationExecutor;
        this.listenerBuildOperationDecorator = listenerBuildOperationDecorator;
        this.coordinationService = coordinationService;
        this.gradleInternal = gradleInternal;
        this.graphListeners = graphListeners;
        this.taskListeners = taskListeners;
        this.executionPlan = new DefaultExecutionPlan(workerLeaseService, gradleInternal, taskNodeFactory, dependencyResolver);
    }

    @Override
    public void setContinueOnFailure(boolean continueOnFailure) {
        this.executionPlan.setContinueOnFailure(continueOnFailure);
    }

    @Override
    public void useFilter(Spec<? super Task> filter) {
        Spec castFilter = (Spec)Cast.uncheckedNonnullCast(filter != null ? filter : Specs.SATISFIES_ALL);
        this.executionPlan.useFilter(castFilter);
        this.graphState = GraphState.DIRTY;
    }

    @Override
    public void addEntryTasks(Iterable<? extends Task> tasks) {
        assert (tasks != null);
        Timer clock = Time.startTimer();
        LinkedHashSet<Task> taskSet = new LinkedHashSet<Task>();
        for (Task task : tasks) {
            taskSet.add(task);
            this.requestedTasks.add(task);
        }
        this.executionPlan.addEntryTasks(taskSet);
        this.graphState = GraphState.DIRTY;
        LOGGER.debug("Timing: Creating the DAG took " + clock.getElapsed());
    }

    @Override
    public void populate() {
        this.ensurePopulated();
    }

    @Override
    public void execute(Collection<? super Throwable> failures) {
        ProjectExecutionServiceRegistry projectExecutionServices = new ProjectExecutionServiceRegistry();
        try {
            this.executeWithServices(projectExecutionServices, failures);
        }
        finally {
            projectExecutionServices.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithServices(ProjectExecutionServiceRegistry projectExecutionServices, Collection<? super Throwable> failures) {
        Timer clock = Time.startTimer();
        this.ensurePopulated();
        if (!this.hasFiredWhenReady) {
            ProjectStateRegistry projectStateRegistry = this.gradleInternal.getServices().get(ProjectStateRegistry.class);
            projectStateRegistry.withLenientState(new Runnable(){

                @Override
                public void run() {
                    DefaultTaskExecutionGraph.this.buildOperationExecutor.run(new NotifyTaskGraphWhenReady(DefaultTaskExecutionGraph.this, (TaskExecutionGraphListener)DefaultTaskExecutionGraph.this.graphListeners.getSource(), DefaultTaskExecutionGraph.this.gradleInternal));
                }
            });
            this.hasFiredWhenReady = true;
        } else if (!this.graphListeners.isEmpty()) {
            LOGGER.warn("Ignoring listeners of task graph ready event, as this build (" + this.gradleInternal.getIdentityPath() + ") has already executed work.");
        }
        try {
            this.planExecutor.process(this.executionPlan, failures, new BuildOperationAwareExecutionAction(this.buildOperationExecutor.getCurrentOperation(), new InvokeNodeExecutorsAction(this.nodeExecutors, projectExecutionServices)));
            LOGGER.debug("Timing: Executing the DAG took " + clock.getElapsed());
            this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                @Override
                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    DefaultTaskExecutionGraph.this.executionPlan.clear();
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
        }
        catch (Throwable throwable) {
            this.coordinationService.withStateLock(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    @Override
    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.add(this.listenerBuildOperationDecorator.decorate("TaskExecutionGraph.addTaskExecutionGraphListener", TaskExecutionGraphListener.class, listener));
    }

    @Override
    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.remove(listener);
    }

    @Override
    public void whenReady(Closure closure) {
        this.graphListeners.add(new ClosureBackedMethodInvocationDispatch("graphPopulated", this.listenerBuildOperationDecorator.decorate("TaskExecutionGraph.whenReady", closure)));
    }

    @Override
    public void whenReady(final Action<TaskExecutionGraph> action) {
        this.graphListeners.add(this.listenerBuildOperationDecorator.decorate("TaskExecutionGraph.whenReady", TaskExecutionGraphListener.class, new TaskExecutionGraphListener(){

            @Override
            public void graphPopulated(TaskExecutionGraph graph) {
                action.execute(graph);
            }
        }));
    }

    @Override
    public void addTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.add(listener);
    }

    @Override
    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.remove(listener);
    }

    @Override
    public void beforeTask(Closure closure) {
        this.taskListeners.add(new ClosureBackedMethodInvocationDispatch("beforeExecute", closure));
    }

    @Override
    public void beforeTask(final Action<Task> action) {
        this.taskListeners.add(new TaskExecutionAdapter(){

            @Override
            public void beforeExecute(Task task) {
                action.execute(task);
            }
        });
    }

    @Override
    public void afterTask(Closure closure) {
        this.taskListeners.add(new ClosureBackedMethodInvocationDispatch("afterExecute", closure));
    }

    @Override
    public void afterTask(final Action<Task> action) {
        this.taskListeners.add(new TaskExecutionAdapter(){

            @Override
            public void afterExecute(Task task, TaskState state) {
                action.execute(task);
            }
        });
    }

    @Override
    public boolean hasTask(Task task) {
        this.ensurePopulated();
        return this.executionPlan.getTasks().contains(task);
    }

    @Override
    public boolean hasTask(String path) {
        this.ensurePopulated();
        for (Task task : this.executionPlan.getTasks()) {
            if (!task.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.executionPlan.size();
    }

    @Override
    public List<Task> getAllTasks() {
        this.ensurePopulated();
        if (this.allTasks == null) {
            this.allTasks = ImmutableList.copyOf(this.executionPlan.getTasks());
        }
        return this.allTasks;
    }

    @Override
    public Set<Task> getDependencies(Task task) {
        this.ensurePopulated();
        TaskNode node = this.executionPlan.getNode(task);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node dependencyNode : node.getDependencySuccessors()) {
            if (!(dependencyNode instanceof TaskNode)) continue;
            builder.add((Object)((TaskNode)dependencyNode).getTask());
        }
        return builder.build();
    }

    private void ensurePopulated() {
        switch (this.graphState) {
            case EMPTY: {
                throw new IllegalStateException("Task information is not available, as this task execution graph has not been populated.");
            }
            case DIRTY: {
                this.executionPlan.determineExecutionPlan();
                this.allTasks = null;
                this.graphState = GraphState.POPULATED;
                return;
            }
        }
    }

    @Override
    public Set<Task> getRequestedTasks() {
        return this.requestedTasks;
    }

    @Override
    public Set<Task> getFilteredTasks() {
        return this.executionPlan.getFilteredTasks();
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.gradleInternal.getRootProject();
    }

    private static class NotifyTaskGraphWhenReady
    implements RunnableBuildOperation {
        private final TaskExecutionGraph taskExecutionGraph;
        private final TaskExecutionGraphListener graphListener;
        private final GradleInternal gradleInternal;

        private NotifyTaskGraphWhenReady(TaskExecutionGraph taskExecutionGraph, TaskExecutionGraphListener graphListener, GradleInternal gradleInternal) {
            this.taskExecutionGraph = taskExecutionGraph;
            this.graphListener = graphListener;
            this.gradleInternal = gradleInternal;
        }

        @Override
        public void run(BuildOperationContext context) {
            this.graphListener.graphPopulated(this.taskExecutionGraph);
            context.setResult(NotifyTaskGraphWhenReadyBuildOperationType.RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName(this.gradleInternal.contextualize("Notify task graph whenReady listeners")).details(new NotifyTaskGraphWhenReadyBuildOperationType.DetailsImpl(this.gradleInternal.getIdentityPath()));
        }
    }

    private static class InvokeNodeExecutorsAction
    implements Action<Node> {
        private final List<NodeExecutor> nodeExecutors;
        private final ProjectExecutionServiceRegistry projectExecutionServices;

        public InvokeNodeExecutorsAction(List<NodeExecutor> nodeExecutors, ProjectExecutionServiceRegistry projectExecutionServices) {
            this.nodeExecutors = nodeExecutors;
            this.projectExecutionServices = projectExecutionServices;
        }

        @Override
        public void execute(Node node) {
            for (NodeExecutor nodeExecutor : this.nodeExecutors) {
                if (!nodeExecutor.execute(node, this.projectExecutionServices)) continue;
                return;
            }
            throw new IllegalStateException("Unknown type of node: " + node);
        }
    }

    private static class BuildOperationAwareExecutionAction
    implements Action<Node> {
        private final BuildOperationRef parentOperation;
        private final Action<Node> delegate;

        BuildOperationAwareExecutionAction(BuildOperationRef parentOperation, Action<Node> delegate) {
            this.parentOperation = parentOperation;
            this.delegate = delegate;
        }

        @Override
        public void execute(Node node) {
            BuildOperationRef previous = CurrentBuildOperationRef.instance().get();
            CurrentBuildOperationRef.instance().set(this.parentOperation);
            try {
                this.delegate.execute(node);
            }
            finally {
                CurrentBuildOperationRef.instance().set(previous);
            }
        }
    }

    private static enum GraphState {
        EMPTY,
        DIRTY,
        POPULATED;

    }
}

