/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.MutableReference;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

@NonNullApi
public class DefaultPlanExecutor
implements PlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(DefaultPlanExecutor.class);
    private final int executorCount;
    private final ExecutorFactory executorFactory;
    private final WorkerLeaseService workerLeaseService;
    private final BuildCancellationToken cancellationToken;
    private final ResourceLockCoordinationService coordinationService;

    public DefaultPlanExecutor(ParallelismConfiguration parallelismConfiguration, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        this.executorFactory = executorFactory;
        this.cancellationToken = cancellationToken;
        this.coordinationService = coordinationService;
        int numberOfParallelExecutors = parallelismConfiguration.getMaxWorkerCount();
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ExecutionPlan executionPlan, Collection<? super Throwable> failures, Action<Node> nodeExecutor) {
        ManagedExecutor executor = this.executorFactory.create("Execution worker for '" + executionPlan.getDisplayName() + "'");
        try {
            WorkerLeaseRegistry.WorkerLease parentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
            this.startAdditionalWorkers(executionPlan, nodeExecutor, executor, parentWorkerLease);
            new ExecutorWorker(executionPlan, nodeExecutor, parentWorkerLease, this.cancellationToken, this.coordinationService).run();
            this.awaitCompletion(executionPlan, failures);
        }
        finally {
            executor.stop();
        }
    }

    private void awaitCompletion(final ExecutionPlan executionPlan, final Collection<? super Throwable> failures) {
        this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            @Override
            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                if (executionPlan.allNodesComplete()) {
                    executionPlan.collectFailures(failures);
                    return ResourceLockState.Disposition.FINISHED;
                }
                return ResourceLockState.Disposition.RETRY;
            }
        });
    }

    private void startAdditionalWorkers(ExecutionPlan executionPlan, Action<? super Node> nodeExecutor, Executor executor, WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
        LOGGER.debug("Using {} parallel executor threads", this.executorCount);
        for (int i = 1; i < this.executorCount; ++i) {
            executor.execute(new ExecutorWorker(executionPlan, nodeExecutor, parentWorkerLease, this.cancellationToken, this.coordinationService));
        }
    }

    private static class ExecutorWorker
    implements Runnable {
        private final ExecutionPlan executionPlan;
        private final Action<? super Node> nodeExecutor;
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private final BuildCancellationToken cancellationToken;
        private final ResourceLockCoordinationService coordinationService;

        private ExecutorWorker(ExecutionPlan executionPlan, Action<? super Node> nodeExecutor, WorkerLeaseRegistry.WorkerLease parentWorkerLease, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
            this.executionPlan = executionPlan;
            this.nodeExecutor = nodeExecutor;
            this.parentWorkerLease = parentWorkerLease;
            this.cancellationToken = cancellationToken;
            this.coordinationService = coordinationService;
        }

        @Override
        public void run() {
            boolean nodesRemaining;
            final AtomicLong busy = new AtomicLong(0L);
            Timer totalTimer = Time.startTimer();
            final Timer executionTimer = Time.startTimer();
            WorkerLeaseRegistry.WorkerLease childLease = this.parentWorkerLease.createChild();
            while (nodesRemaining = this.executeNextNode(childLease, new Action<Node>(){

                @Override
                public void execute(Node work) {
                    LOGGER.info("{} ({}) started.", work, Thread.currentThread());
                    executionTimer.reset();
                    ExecutorWorker.this.nodeExecutor.execute(work);
                    long duration = executionTimer.getElapsedMillis();
                    busy.addAndGet(duration);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("{} ({}) completed. Took {}.", work, Thread.currentThread(), TimeFormatting.formatDurationVerbose(duration));
                    }
                }
            })) {
            }
            long total = totalTimer.getElapsedMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Execution worker [{}] finished, busy: {}, idle: {}", Thread.currentThread(), TimeFormatting.formatDurationVerbose(busy.get()), TimeFormatting.formatDurationVerbose(total - busy.get()));
            }
        }

        private boolean executeNextNode(final WorkerLeaseRegistry.WorkerLease workerLease, Action<Node> nodeExecutor) {
            final MutableReference selected = MutableReference.empty();
            final MutableBoolean nodesRemaining = new MutableBoolean();
            this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                @Override
                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    if (ExecutorWorker.this.cancellationToken.isCancellationRequested()) {
                        ExecutorWorker.this.executionPlan.cancelExecution();
                    }
                    nodesRemaining.set(ExecutorWorker.this.executionPlan.hasNodesRemaining());
                    if (!nodesRemaining.get()) {
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    try {
                        selected.set(ExecutorWorker.this.executionPlan.selectNext(workerLease, resourceLockState));
                    }
                    catch (Throwable t) {
                        resourceLockState.releaseLocks();
                        ExecutorWorker.this.executionPlan.abortAllAndFail(t);
                        nodesRemaining.set(false);
                    }
                    if (selected.get() == null && nodesRemaining.get()) {
                        return ResourceLockState.Disposition.RETRY;
                    }
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
            Node selectedNode = (Node)selected.get();
            if (selectedNode != null) {
                this.execute(selectedNode, workerLease, nodeExecutor);
            }
            return nodesRemaining.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Node selected, WorkerLeaseRegistry.WorkerLease workerLease, Action<Node> nodeExecutor) {
            try {
                if (!selected.isComplete()) {
                    try {
                        nodeExecutor.execute(selected);
                    }
                    catch (Throwable e) {
                        selected.setExecutionFailure(e);
                    }
                }
                this.coordinationService.withStateLock(new Transformer<ResourceLockState.Disposition, ResourceLockState>(selected, workerLease){
                    final /* synthetic */ Node val$selected;
                    final /* synthetic */ WorkerLeaseRegistry.WorkerLease val$workerLease;
                    {
                        this.val$selected = node;
                        this.val$workerLease = workerLease;
                    }

                    @Override
                    public ResourceLockState.Disposition transform(ResourceLockState state) {
                        ExecutorWorker.this.executionPlan.nodeComplete(this.val$selected);
                        return DefaultResourceLockCoordinationService.unlock(this.val$workerLease).transform(state);
                    }
                });
            }
            catch (Throwable throwable) {
                this.coordinationService.withStateLock(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }
}

