/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.internal;

import groovy.lang.Closure;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.configuration.internal.ExecuteListenerBuildOperationType;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configuration.internal.UserCodeApplicationId;
import org.gradle.internal.InternalListener;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.org.apache.commons.lang.ClassUtils;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class DefaultListenerBuildOperationDecorator
implements ListenerBuildOperationDecorator {
    private static final ImmutableSet<Class<?>> SUPPORTED_INTERFACES = ImmutableSet.of(BuildListener.class, ProjectEvaluationListener.class, TaskExecutionGraphListener.class);
    private static final ImmutableSet<String> UNDECORATED_METHOD_NAMES = ImmutableSet.of((Object)"buildStarted", (Object)"settingsEvaluated", (Object)"buildFinished");
    private final BuildOperationExecutor buildOperationExecutor;
    private final UserCodeApplicationContext userCodeApplicationContext;

    public DefaultListenerBuildOperationDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }

    @Override
    public <T> Action<T> decorate(String registrationPoint, Action<T> action) {
        UserCodeApplicationId applicationId = this.userCodeApplicationContext.current();
        if (applicationId == null || action instanceof InternalListener) {
            return action;
        }
        return new BuildOperationEmittingAction(applicationId, registrationPoint, action);
    }

    @Override
    public <T> Closure<T> decorate(String registrationPoint, Closure<T> closure) {
        UserCodeApplicationId applicationId = this.userCodeApplicationContext.current();
        if (applicationId == null) {
            return closure;
        }
        return new BuildOperationEmittingClosure(applicationId, registrationPoint, closure);
    }

    @Override
    public <T> T decorate(String registrationPoint, Class<T> targetClass, T listener) {
        if (listener instanceof InternalListener || !DefaultListenerBuildOperationDecorator.isSupported(listener)) {
            return listener;
        }
        UserCodeApplicationId applicationId = this.userCodeApplicationContext.current();
        if (applicationId == null) {
            return listener;
        }
        Class<?> listenerClass = listener.getClass();
        List allInterfaces = ClassUtils.getAllInterfaces(listenerClass);
        BuildOperationEmittingInvocationHandler handler = new BuildOperationEmittingInvocationHandler(applicationId, registrationPoint, listener);
        return targetClass.cast(Proxy.newProxyInstance(listenerClass.getClassLoader(), allInterfaces.toArray(new Class[0]), (InvocationHandler)handler));
    }

    @Override
    public Object decorateUnknownListener(String registrationPoint, Object listener) {
        return this.decorate(registrationPoint, Object.class, listener);
    }

    private static boolean isSupported(Object listener) {
        for (Class i : SUPPORTED_INTERFACES) {
            if (!i.isInstance(listener)) continue;
            return true;
        }
        return false;
    }

    private class BuildOperationEmittingInvocationHandler
    implements InvocationHandler {
        private final UserCodeApplicationId applicationId;
        private final String registrationPoint;
        private final Object delegate;

        private BuildOperationEmittingInvocationHandler(UserCodeApplicationId applicationId, String registrationPoint, Object delegate) {
            this.applicationId = applicationId;
            this.registrationPoint = registrationPoint;
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("toString") && (args == null || args.length == 0)) {
                return "BuildOperationEmittingBuildListenerInvocationHandler{delegate: " + this.delegate + "}";
            }
            if (methodName.equals("hashCode") && (args == null || args.length == 0)) {
                return this.delegate.hashCode();
            }
            if (methodName.equals("equals") && args.length == 1) {
                return proxy == args[0] || this.isSame(args[0]);
            }
            if (!SUPPORTED_INTERFACES.contains(method.getDeclaringClass()) || UNDECORATED_METHOD_NAMES.contains((Object)methodName)) {
                try {
                    return method.invoke(this.delegate, args);
                }
                catch (InvocationTargetException e) {
                    throw UncheckedException.unwrapAndRethrow(e);
                }
            }
            DefaultListenerBuildOperationDecorator.this.buildOperationExecutor.run(new Operation(this.applicationId, this.registrationPoint){

                @Override
                public void run(final BuildOperationContext context) {
                    DefaultListenerBuildOperationDecorator.this.userCodeApplicationContext.reapply(BuildOperationEmittingInvocationHandler.this.applicationId, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                method.invoke(BuildOperationEmittingInvocationHandler.this.delegate, args);
                                context.setResult(ExecuteListenerBuildOperationType.RESULT);
                            }
                            catch (InvocationTargetException e) {
                                throw UncheckedException.unwrapAndRethrow(e);
                            }
                            catch (Exception e) {
                                throw UncheckedException.throwAsUncheckedException(e);
                            }
                        }
                    });
                }
            });
            return null;
        }

        private boolean isSame(Object arg) {
            if (Proxy.isProxyClass(arg.getClass())) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(arg);
                if (this.getClass() == invocationHandler.getClass()) {
                    BuildOperationEmittingInvocationHandler cast = (BuildOperationEmittingInvocationHandler)invocationHandler;
                    return cast.delegate.equals(this.delegate);
                }
            }
            return false;
        }
    }

    private class BuildOperationEmittingClosure<T>
    extends Closure<T> {
        private final UserCodeApplicationId applicationId;
        private final String registrationPoint;
        private final Closure<T> delegate;

        private BuildOperationEmittingClosure(UserCodeApplicationId application, String registrationPoint, Closure<T> delegate) {
            super(delegate.getOwner(), delegate.getThisObject());
            this.applicationId = application;
            this.delegate = delegate;
            this.registrationPoint = registrationPoint;
        }

        public void doCall(final Object ... args) {
            DefaultListenerBuildOperationDecorator.this.buildOperationExecutor.run(new Operation(this.applicationId, this.registrationPoint){

                @Override
                public void run(final BuildOperationContext context) {
                    DefaultListenerBuildOperationDecorator.this.userCodeApplicationContext.reapply(BuildOperationEmittingClosure.this.applicationId, new Runnable(){

                        @Override
                        public void run() {
                            int numClosureArgs = BuildOperationEmittingClosure.this.delegate.getMaximumNumberOfParameters();
                            Object[] finalArgs = numClosureArgs < args.length ? Arrays.copyOf(args, numClosureArgs) : args;
                            BuildOperationEmittingClosure.this.delegate.call(finalArgs);
                            context.setResult(ExecuteListenerBuildOperationType.RESULT);
                        }
                    });
                }
            });
        }

        public void setDelegate(Object delegateObject) {
            this.delegate.setDelegate(delegateObject);
        }

        public void setResolveStrategy(int resolveStrategy) {
            this.delegate.setResolveStrategy(resolveStrategy);
        }

        public int getMaximumNumberOfParameters() {
            return this.delegate.getMaximumNumberOfParameters();
        }
    }

    private class BuildOperationEmittingAction<T>
    implements Action<T> {
        private final UserCodeApplicationId applicationId;
        private final String registrationPoint;
        private final Action<T> delegate;

        private BuildOperationEmittingAction(UserCodeApplicationId applicationId, String registrationPoint, Action<T> delegate) {
            this.applicationId = applicationId;
            this.delegate = delegate;
            this.registrationPoint = registrationPoint;
        }

        @Override
        public void execute(final T arg) {
            DefaultListenerBuildOperationDecorator.this.buildOperationExecutor.run(new Operation(this.applicationId, this.registrationPoint){

                @Override
                public void run(BuildOperationContext context) {
                    DefaultListenerBuildOperationDecorator.this.userCodeApplicationContext.reapply(BuildOperationEmittingAction.this.applicationId, new Runnable(){

                        @Override
                        public void run() {
                            BuildOperationEmittingAction.this.delegate.execute(arg);
                        }
                    });
                    context.setResult(ExecuteListenerBuildOperationType.RESULT);
                }
            });
        }
    }

    private static abstract class Operation
    implements RunnableBuildOperation {
        private final UserCodeApplicationId applicationId;
        private final String registrationPoint;

        Operation(UserCodeApplicationId applicationId, String registrationPoint) {
            this.applicationId = applicationId;
            this.registrationPoint = registrationPoint;
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Execute " + this.registrationPoint + " listener").details(new ExecuteListenerBuildOperationType.DetailsImpl(this.applicationId, this.registrationPoint));
        }
    }
}

