/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.util.SingleMessageLogger;

public class DefaultBuildConfigurer
implements BuildConfigurer {
    private final ProjectConfigurer projectConfigurer;
    private final BuildStateRegistry buildRegistry;

    public DefaultBuildConfigurer(ProjectConfigurer projectConfigurer, BuildStateRegistry buildRegistry) {
        this.projectConfigurer = projectConfigurer;
        this.buildRegistry = buildRegistry;
    }

    @Override
    public void configure(GradleInternal gradle) {
        this.maybeInformAboutIncubatingMode(gradle);
        if (gradle.getParent() == null) {
            this.buildRegistry.beforeConfigureRootBuild();
        }
        if (gradle.getStartParameter().isConfigureOnDemand()) {
            this.projectConfigurer.configure(gradle.getRootProject());
        } else {
            this.projectConfigurer.configureHierarchy(gradle.getRootProject());
        }
    }

    private void maybeInformAboutIncubatingMode(GradleInternal gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        if (startParameter.isConfigureOnDemand()) {
            SingleMessageLogger.incubatingFeatureUsed("Configuration on demand");
        }
    }
}

