/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.caching.internal.tasks.BuildCacheKeyInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.util.Path;

@NonNullApi
public class DefaultTaskOutputCachingBuildCacheKeyBuilder
implements TaskOutputCachingBuildCacheKeyBuilder {
    private final Hasher hasher = Hashing.newHasher();
    private final Path taskPath;
    private ImplementationSnapshot taskImplementation;
    private ImmutableList<ImplementationSnapshot> actionImplementations;
    private final ImmutableSortedMap.Builder<String, HashCode> inputValueHashes = ImmutableSortedMap.naturalOrder();
    private final ImmutableSortedMap.Builder<String, CurrentFileCollectionFingerprint> inputFiles = ImmutableSortedMap.naturalOrder();
    private final ImmutableSortedMap.Builder<String, String> nonCacheableInputProperties = ImmutableSortedMap.naturalOrder();
    private final ImmutableSortedSet.Builder<String> outputPropertyNames = ImmutableSortedSet.naturalOrder();

    public DefaultTaskOutputCachingBuildCacheKeyBuilder(Path taskPath) {
        this.taskPath = taskPath;
    }

    @Override
    public void appendTaskImplementation(ImplementationSnapshot taskImplementation) {
        this.taskImplementation = taskImplementation;
        taskImplementation.appendToHasher(this.hasher);
    }

    @Override
    public void appendTaskActionImplementations(Collection<ImplementationSnapshot> taskActionImplementations) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImplementationSnapshot actionImpl : taskActionImplementations) {
            builder.add((Object)actionImpl);
            actionImpl.appendToHasher(this.hasher);
        }
        this.actionImplementations = builder.build();
    }

    @Override
    public void appendInputValuePropertyHash(String propertyName, HashCode hashCode) {
        this.hasher.putString(propertyName);
        this.hasher.putHash(hashCode);
        this.inputValueHashes.put((Object)propertyName, (Object)hashCode);
    }

    @Override
    public void appendInputFilesProperty(String propertyName, CurrentFileCollectionFingerprint fileCollectionFingerprint) {
        this.hasher.putString(propertyName);
        this.hasher.putHash(fileCollectionFingerprint.getHash());
        this.inputFiles.put((Object)propertyName, (Object)fileCollectionFingerprint);
    }

    @Override
    public void inputPropertyNotCacheable(String propertyName, String nonCacheableReason) {
        this.hasher.markAsInvalid(nonCacheableReason);
        this.nonCacheableInputProperties.put((Object)propertyName, (Object)nonCacheableReason);
    }

    @Override
    public void appendOutputPropertyName(String propertyName) {
        this.outputPropertyNames.add((Object)propertyName);
        this.hasher.putString(propertyName);
    }

    @Override
    public TaskOutputCachingBuildCacheKey build() {
        BuildCacheKeyInputs inputs = new BuildCacheKeyInputs(this.taskImplementation, this.actionImplementations, (ImmutableSortedMap<String, HashCode>)this.inputValueHashes.build(), (ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)this.inputFiles.build(), (ImmutableSortedMap<String, String>)this.nonCacheableInputProperties.build(), (ImmutableSortedSet<String>)this.outputPropertyNames.build());
        HashCode hash = !this.hasher.isValid() ? null : this.hasher.hash();
        return new DefaultTaskOutputCachingBuildCacheKey(this.taskPath, hash, inputs);
    }

    private static class DefaultTaskOutputCachingBuildCacheKey
    implements TaskOutputCachingBuildCacheKey {
        private final Path taskPath;
        private final HashCode hashCode;
        private final BuildCacheKeyInputs inputs;

        private DefaultTaskOutputCachingBuildCacheKey(Path taskPath, @Nullable HashCode hashCode, BuildCacheKeyInputs inputs) {
            this.taskPath = taskPath;
            this.hashCode = hashCode;
            this.inputs = inputs;
        }

        @Override
        public Path getTaskPath() {
            return this.taskPath;
        }

        @Override
        public String getHashCode() {
            return ((HashCode)Preconditions.checkNotNull((Object)this.hashCode, (Object)"Cannot determine hash code for invalid build cache key")).toString();
        }

        @Override
        public BuildCacheKeyInputs getInputs() {
            return this.inputs;
        }

        @Override
        public byte[] getHashCodeBytes() {
            return this.hashCode == null ? null : this.hashCode.toByteArray();
        }

        @Override
        public boolean isValid() {
            return this.hashCode != null;
        }

        @Override
        public String getDisplayName() {
            if (this.hashCode == null) {
                return "INVALID cache key for task '" + this.taskPath + "'";
            }
            return this.hashCode + " for task '" + this.taskPath + "'";
        }

        public String toString() {
            return String.valueOf(this.hashCode);
        }
    }
}

