/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;

public class ScalaLibraryProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public ScalaLibraryProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super("scala", scriptBuilderFactory, templateOperationFactory, fileResolver, libraryVersionProvider);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public String getId() {
        return "scala-library";
    }

    @Override
    protected void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generate(settings, buildScriptBuilder);
        String scalaVersion = this.libraryVersionProvider.getVersion("scala");
        String scalaLibraryVersion = this.libraryVersionProvider.getVersion("scala-library");
        String scalaTestVersion = this.libraryVersionProvider.getVersion("scalatest");
        String junitVersion = this.libraryVersionProvider.getVersion("junit");
        String scalaXmlVersion = this.libraryVersionProvider.getVersion("scala-xml");
        buildScriptBuilder.fileComment("This generated file contains a sample Scala library project to get you started.").fileComment("For more details take a look at the Scala plugin chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("scala_plugin")).plugin("Apply the scala plugin to add support for Scala", "scala").implementationDependency("Use Scala " + scalaVersion + " in our library project", "org.scala-lang:scala-library:" + scalaLibraryVersion).testImplementationDependency("Use Scalatest for testing our library", "junit:junit:" + junitVersion, "org.scalatest:scalatest_" + scalaVersion + ":" + scalaTestVersion).testRuntimeOnlyDependency("Need scala-xml at test runtime", "org.scala-lang.modules:scala-xml_" + scalaVersion + ":" + scalaXmlVersion);
        TemplateOperation scalaLibTemplateOperation = this.fromClazzTemplate("scalalibrary/Library.scala.template", settings, "main");
        TemplateOperation scalaTestTemplateOperation = this.fromClazzTemplate("scalalibrary/LibrarySuite.scala.template", settings, "test");
        this.whenNoSourcesAvailable(scalaLibTemplateOperation, scalaTestTemplateOperation).generate();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.SCALATEST;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.SCALATEST);
    }
}

