/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;

public abstract class JavaProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private static final Description DESCRIPTION = new Description("Java", "Java Quickstart", "tutorial_java_projects", "java");
    private final DocumentationRegistry documentationRegistry;

    public JavaProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super("java", scriptBuilderFactory, templateOperationFactory, fileResolver, libraryVersionProvider);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    protected void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generate(settings, buildScriptBuilder);
        Description desc = this.getDescription();
        buildScriptBuilder.fileComment("This generated file contains a sample " + desc.projectType + " project to get you started.").fileComment("For more details take a look at the " + desc.chapterName + " chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor(desc.userguideId)).plugin("Apply the " + desc.pluginName + " plugin to add support for " + desc.projectType, desc.pluginName);
        this.configureBuildScript(settings, buildScriptBuilder);
        this.addTestFramework(settings.getTestFramework(), buildScriptBuilder);
        TemplateOperation sourceTemplate = this.sourceTemplateOperation(settings);
        TemplateOperation testSourceTemplate = this.testTemplateOperation(settings);
        this.whenNoSourcesAvailable(sourceTemplate, testSourceTemplate).generate();
    }

    protected Description getDescription() {
        return DESCRIPTION;
    }

    protected String getImplementationConfigurationName() {
        return "implementation";
    }

    protected String getTestImplementationConfigurationName() {
        return "testImplementation";
    }

    private void addTestFramework(BuildInitTestFramework testFramework, BuildScriptBuilder buildScriptBuilder) {
        switch (testFramework) {
            case SPOCK: {
                buildScriptBuilder.plugin("Apply the groovy plugin to also add support for Groovy (needed for Spock)", "groovy").dependency(this.getTestImplementationConfigurationName(), "Use the latest Groovy version for Spock testing", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).dependency(this.getTestImplementationConfigurationName(), "Use the awesome Spock testing and specification framework even with Java", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"), "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
                break;
            }
            case TESTNG: {
                buildScriptBuilder.dependency(this.getTestImplementationConfigurationName(), "Use TestNG framework, also requires calling test.useTestNG() below", "org.gradle.internal.impldep.org.testng:testng:" + this.libraryVersionProvider.getVersion("testng")).taskMethodInvocation("Use TestNG for unit tests", "test", "Test", "useTestNG", new Object[0]);
                break;
            }
            default: {
                buildScriptBuilder.dependency(this.getTestImplementationConfigurationName(), "Use JUnit test framework", "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
            }
        }
    }

    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.dependency(this.getImplementationConfigurationName(), "This dependency is found on compile classpath of this component and consumers.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
    }

    protected abstract TemplateOperation sourceTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation testTemplateOperation(InitSettings var1);

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.JUNIT;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return new TreeSet<BuildInitTestFramework>(Arrays.asList(BuildInitTestFramework.JUNIT, BuildInitTestFramework.TESTNG, BuildInitTestFramework.SPOCK));
    }

    protected static class Description {
        private final String projectType;
        private final String chapterName;
        private final String userguideId;
        private final String pluginName;

        public Description(String projectType, String chapterName, String userguideId, String pluginName) {
            this.projectType = projectType;
            this.chapterName = chapterName;
            this.userguideId = userguideId;
            this.pluginName = pluginName;
        }
    }
}

