/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.tasks.diagnostics.internal.graph.LegendRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvableConfigurationResult;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.StyledTextOutput;

public class DependencyGraphsRenderer {
    private final StyledTextOutput output;
    private final GraphRenderer renderer;
    private final NodeRenderer rootRenderer;
    private final NodeRenderer dependenciesRenderer;
    private final LegendRenderer legendRenderer;
    private boolean showSinglePath;

    public DependencyGraphsRenderer(StyledTextOutput output, GraphRenderer renderer, NodeRenderer rootRenderer, NodeRenderer dependenciesRenderer) {
        this.output = output;
        this.renderer = renderer;
        this.rootRenderer = rootRenderer;
        this.dependenciesRenderer = dependenciesRenderer;
        this.legendRenderer = new LegendRenderer(output);
    }

    public boolean isShowSinglePath() {
        return this.showSinglePath;
    }

    public void setShowSinglePath(boolean showSinglePath) {
        this.showSinglePath = showSinglePath;
    }

    public void render(Collection<RenderableDependency> items) {
        int i = 0;
        int size = items.size();
        for (RenderableDependency item : items) {
            boolean last;
            this.renderRoot(item);
            if (last = ++i == size) continue;
            this.output.println();
        }
    }

    private void renderRoot(RenderableDependency root) {
        if (root instanceof UnresolvableConfigurationResult) {
            this.legendRenderer.setHasUnresolvableConfigurations(true);
        }
        if (this.rootRenderer != NodeRenderer.NO_OP) {
            this.renderNode(root, true, false, this.rootRenderer);
        }
        HashSet visited = Sets.newHashSet();
        visited.add(root.getId());
        this.renderChildren(root.getChildren(), visited);
    }

    private void renderChildren(Set<? extends RenderableDependency> children, Set<Object> visited) {
        int count;
        int i = 0;
        int childCould = children.size();
        int n = count = this.showSinglePath ? Math.min(1, childCould) : childCould;
        if (count > 0) {
            this.renderer.startChildren();
            for (RenderableDependency renderableDependency : children) {
                boolean last = ++i == count;
                this.doRender(renderableDependency, last, visited);
                if (!last) continue;
                break;
            }
            this.renderer.completeChildren();
        }
    }

    private void doRender(RenderableDependency node, boolean last, Set<Object> visited) {
        boolean alreadyRendered;
        if (node.getResolutionState() == RenderableDependency.ResolutionState.RESOLVED_CONSTRAINT) {
            this.renderNode(node, last, false, this.dependenciesRenderer);
            this.legendRenderer.setHasConstraints(true);
            return;
        }
        boolean bl = alreadyRendered = !visited.add(node.getId());
        if (alreadyRendered) {
            this.legendRenderer.setHasCyclicDependencies(true);
        }
        this.renderNode(node, last, alreadyRendered, this.dependenciesRenderer);
        if (!alreadyRendered) {
            Set<? extends RenderableDependency> children = node.getChildren();
            this.renderChildren(children, visited);
        }
    }

    private void renderNode(final RenderableDependency node, boolean isLast, final boolean isDuplicate, final NodeRenderer dependenciesRenderer) {
        this.renderer.visit((Action<? super StyledTextOutput>)new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput output) {
                dependenciesRenderer.renderNode(output, node, isDuplicate);
            }
        }, isLast);
    }

    public void complete() {
        this.legendRenderer.printLegend();
    }
}

