/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.locking.LockOutOfDateException;
import org.gradle.internal.logging.text.StyledTextOutput;

class ResolutionErrorRenderer
implements Action<Throwable> {
    private final Spec<DependencyResult> dependencySpec;
    private final List<Action<StyledTextOutput>> errorActions = Lists.newArrayListWithExpectedSize((int)1);

    public ResolutionErrorRenderer(Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    @Override
    public void execute(Throwable throwable) {
        if (!(throwable instanceof ResolveException)) {
            throw UncheckedException.throwAsUncheckedException(throwable);
        }
        Throwable cause = throwable.getCause();
        this.handleResolutionError(cause);
    }

    private void handleResolutionError(Throwable cause) {
        if (cause instanceof VersionConflictException) {
            this.handleConflict((VersionConflictException)cause);
        } else if (cause instanceof LockOutOfDateException) {
            this.handleOutOfDateLocks((LockOutOfDateException)cause);
        } else {
            throw UncheckedException.throwAsUncheckedException(cause);
        }
    }

    private void handleOutOfDateLocks(final LockOutOfDateException cause) {
        this.registerError(new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput output) {
                List<String> errors = cause.getErrors();
                output.text("The dependency locks are out-of-date:");
                output.println();
                for (String error : errors) {
                    output.text("   - " + error);
                    output.println();
                }
                output.println();
            }
        });
    }

    private void handleConflict(final VersionConflictException conflict) {
        this.registerError(new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput output) {
                for (List<ModuleVersionIdentifier> moduleVersionIdentifiers : conflict.getConflicts()) {
                    boolean matchesSpec = ResolutionErrorRenderer.this.hasVersionConflictOnRequestedDependency(moduleVersionIdentifiers);
                    if (!matchesSpec) continue;
                    output.text("Dependency resolution failed because of conflicts between the following modules:");
                    output.println();
                    for (ModuleVersionIdentifier moduleVersionIdentifier : moduleVersionIdentifiers) {
                        output.text("   - ");
                        output.withStyle(StyledTextOutput.Style.Error).text(moduleVersionIdentifier.toString());
                        output.println();
                    }
                    output.println();
                }
            }
        });
    }

    public void renderErrors(StyledTextOutput output) {
        for (Action<StyledTextOutput> errorAction : this.errorActions) {
            errorAction.execute(output);
        }
    }

    private void registerError(Action<StyledTextOutput> errorAction) {
        this.errorActions.add(errorAction);
    }

    private boolean hasVersionConflictOnRequestedDependency(List<ModuleVersionIdentifier> moduleVersionIdentifiers) {
        boolean matchesSpec = false;
        for (final ModuleVersionIdentifier mvi : moduleVersionIdentifiers) {
            matchesSpec |= this.dependencySpec.isSatisfiedBy(new DependencyResult(){

                @Override
                public ComponentSelector getRequested() {
                    return DefaultModuleComponentSelector.newSelector(mvi.getModule(), mvi.getVersion());
                }

                @Override
                public ResolvedComponentResult getFrom() {
                    return null;
                }

                @Override
                public boolean isConstraint() {
                    return false;
                }
            });
        }
        return matchesSpec;
    }
}

