/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

@NonNullApi
public class SourceTask
extends ConventionTask
implements PatternFilterable {
    private final List<Object> source = new ArrayList<Object>();
    private final PatternFilterable patternSet = this.getPatternSetFactory().create();

    @Inject
    protected Factory<PatternSet> getPatternSetFactory() {
        throw new UnsupportedOperationException();
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileTree getSource() {
        ArrayList<Object> copy = new ArrayList<Object>(this.source);
        FileTree src = this.getProject().files(copy).getAsFileTree();
        return src.matching(this.patternSet);
    }

    public void setSource(FileTree source) {
        this.setSource((Object)source);
    }

    public void setSource(Object source) {
        this.source.clear();
        this.source.add(source);
    }

    public SourceTask source(Object ... sources) {
        Collections.addAll(this.source, sources);
        return this;
    }

    @Override
    public SourceTask include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public SourceTask include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public SourceTask include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public SourceTask include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public SourceTask exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public SourceTask exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public SourceTask exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public SourceTask exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    @Internal
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public SourceTask setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    @Override
    @Internal
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public SourceTask setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }
}

