/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.mvnsettings.LocalMavenRepositoryLocator;
import org.gradle.api.publication.maven.internal.action.MavenPublishAction;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenPublisher
implements MavenPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMavenPublisher.class);
    private final LocalMavenRepositoryLocator mavenRepositoryLocator;

    public AbstractMavenPublisher(LocalMavenRepositoryLocator mavenRepositoryLocator) {
        this.mavenRepositoryLocator = mavenRepositoryLocator;
    }

    @Override
    public void publish(MavenNormalizedPublication publication, MavenArtifactRepository artifactRepository) {
        if (artifactRepository == null) {
            LOGGER.info("Publishing to maven local repository");
        } else {
            LOGGER.info("Publishing to repository '{}' ({})", (Object)artifactRepository.getName(), (Object)artifactRepository.getUrl());
        }
        MavenPublishAction deployTask = this.createDeployTask(publication.getPackaging(), publication.getProjectIdentity(), this.mavenRepositoryLocator, artifactRepository);
        this.addPomAndArtifacts(deployTask, publication);
        this.execute(deployTask);
    }

    protected abstract MavenPublishAction createDeployTask(String var1, MavenProjectIdentity var2, LocalMavenRepositoryLocator var3, MavenArtifactRepository var4);

    private void addPomAndArtifacts(MavenPublishAction publishAction, MavenNormalizedPublication publication) {
        MavenArtifact pomArtifact = publication.getPomArtifact();
        publishAction.setPomArtifact(pomArtifact.getFile());
        MavenArtifact mainArtifact = publication.getMainArtifact();
        if (mainArtifact != null) {
            publishAction.setMainArtifact(mainArtifact.getFile());
        }
        for (MavenArtifact artifact : publication.getAllArtifacts()) {
            if (artifact == mainArtifact || artifact == pomArtifact) continue;
            publishAction.addAdditionalArtifact(artifact.getFile(), Strings.nullToEmpty((String)artifact.getExtension()), Strings.nullToEmpty((String)artifact.getClassifier()));
        }
    }

    private void execute(MavenPublishAction publishAction) {
        publishAction.publish();
    }
}

