/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.validation;

import java.util.Set;
import org.gradle.api.logging.Logger;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.TreeFormatter;

public class PublicationWarningsCollector {
    private final Logger logger;
    private final String unsupportedFeature;
    private final String incompatibleFeature;
    Set<String> unsupportedUsages = null;
    Set<String> incompatibleUsages = null;

    public PublicationWarningsCollector(Logger logger, String unsupportedFeature, String incompatibleFeature) {
        this.logger = logger;
        this.unsupportedFeature = unsupportedFeature;
        this.incompatibleFeature = incompatibleFeature;
    }

    public void addUnsupported(String text) {
        if (this.unsupportedUsages == null) {
            this.unsupportedUsages = Sets.newHashSet();
        }
        this.unsupportedUsages.add(text);
    }

    public void addIncompatible(String text) {
        if (this.incompatibleUsages == null) {
            this.incompatibleUsages = Sets.newHashSet();
        }
        this.incompatibleUsages.add(text);
    }

    public void complete(DisplayName displayName) {
        if (this.unsupportedUsages != null) {
            this.formatAndLog(displayName, this.unsupportedFeature, this.unsupportedUsages);
        }
        if (this.incompatibleUsages != null) {
            this.formatAndLog(displayName, this.incompatibleFeature, this.incompatibleUsages);
        }
    }

    private void formatAndLog(DisplayName displayName, String unsupportedFeature, Set<String> unsupportedUsages) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(displayName + unsupportedFeature);
        formatter.startChildren();
        for (String usage : unsupportedUsages) {
            formatter.node(usage);
        }
        formatter.endChildren();
        this.logger.lifecycle(formatter.toString());
    }
}

