/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultScalaSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.jvm.tasks.Jar;

public class ScalaBasePlugin
implements Plugin<Project> {
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    private final ObjectFactory objectFactory;

    @Inject
    public ScalaBasePlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        Usage incrementalAnalysisUsage = this.objectFactory.named(Usage.class, "incremental-analysis");
        this.configureConfigurations(project, incrementalAnalysisUsage);
        ScalaRuntime scalaRuntime = project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, project);
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime);
        ScalaBasePlugin.configureSourceSetDefaults(project, incrementalAnalysisUsage, this.objectFactory);
        ScalaBasePlugin.configureScaladoc(project, scalaRuntime);
    }

    private void configureConfigurations(final Project project, final Usage incrementalAnalysisUsage) {
        ((Configuration)project.getConfigurations().create(ZINC_CONFIGURATION_NAME)).setVisible(false).setDescription("The Zinc incremental compiler to be used for this Scala project.").defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                dependencies.add(project.getDependencies().create("com.typesafe.zinc:zinc:0.3.15"));
            }
        });
        Configuration incrementalAnalysisElements = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisElements");
        incrementalAnalysisElements.setVisible(false);
        incrementalAnalysisElements.setDescription("Incremental compilation analysis files");
        incrementalAnalysisElements.setCanBeResolved(false);
        incrementalAnalysisElements.setCanBeConsumed(true);
        incrementalAnalysisElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, incrementalAnalysisUsage);
        AttributeMatchingStrategy<Usage> matchingStrategy = project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, new Action<ActionConfiguration>(){

            @Override
            public void execute(ActionConfiguration actionConfiguration) {
                actionConfiguration.params(incrementalAnalysisUsage);
                actionConfiguration.params(ScalaBasePlugin.this.objectFactory.named(Usage.class, "java-api"));
                actionConfiguration.params(ScalaBasePlugin.this.objectFactory.named(Usage.class, "java-runtime-jars"));
            }
        });
    }

    private static void configureSourceSetDefaults(final Project project, final Usage incrementalAnalysisUsage, final ObjectFactory objectFactory) {
        project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(SourceSet sourceSet) {
                String displayName = (String)InvokerHelper.invokeMethod((Object)sourceSet, (String)"getDisplayName", null);
                Convention sourceSetConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
                DefaultScalaSourceSet scalaSourceSet = new DefaultScalaSourceSet(displayName, objectFactory);
                sourceSetConvention.getPlugins().put("scala", scalaSourceSet);
                final SourceDirectorySet scalaDirectorySet = scalaSourceSet.getScala();
                scalaDirectorySet.srcDir(project.file("src/" + sourceSet.getName() + "/scala"));
                sourceSet.getAllJava().source(scalaDirectorySet);
                sourceSet.getAllSource().source(scalaDirectorySet);
                sourceSet.getResources().getFilter().exclude(new Spec<FileTreeElement>(){

                    @Override
                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return scalaDirectorySet.contains(element.getFile());
                    }
                });
                Configuration classpath = project.getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
                Configuration incrementalAnalysis = (Configuration)project.getConfigurations().create("incrementalScalaAnalysisFor" + sourceSet.getName());
                incrementalAnalysis.setVisible(false);
                incrementalAnalysis.setDescription("Incremental compilation analysis files for " + displayName);
                incrementalAnalysis.setCanBeResolved(true);
                incrementalAnalysis.setCanBeConsumed(false);
                incrementalAnalysis.extendsFrom(classpath);
                incrementalAnalysis.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, incrementalAnalysisUsage);
                ScalaBasePlugin.configureScalaCompile(project, sourceSet, incrementalAnalysis, incrementalAnalysisUsage);
            }
        });
    }

    private static void configureScalaCompile(final Project project, final SourceSet sourceSet, final Configuration incrementalAnalysis, Usage incrementalAnalysisUsage) {
        Convention scalaConvention = (Convention)InvokerHelper.getProperty((Object)sourceSet, (String)"convention");
        final ScalaSourceSet scalaSourceSet = scalaConvention.findPlugin(ScalaSourceSet.class);
        final TaskProvider<ScalaCompile> scalaCompile = project.getTasks().register(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, new Action<ScalaCompile>(){

            @Override
            public void execute(ScalaCompile scalaCompile) {
                scalaCompile.dependsOn(sourceSet.getCompileJavaTaskName());
                SourceSetUtil.configureForSourceSet(sourceSet, scalaSourceSet.getScala(), scalaCompile, scalaCompile.getOptions(), project);
                scalaCompile.setDescription("Compiles the " + scalaSourceSet.getScala() + ".");
                scalaCompile.setSource(scalaSourceSet.getScala());
                scalaCompile.getAnalysisMappingFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".mapping"));
                IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                incrementalOptions.getAnalysisFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis"));
                Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
                if (jarTask != null) {
                    incrementalOptions.getPublishedCode().set(jarTask.getArchiveFile());
                }
                scalaCompile.getAnalysisFiles().from(incrementalAnalysis.getIncoming().artifactView((Action<? super ArtifactView.ViewConfiguration>)new Action<ArtifactView.ViewConfiguration>(){

                    @Override
                    public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                        viewConfiguration.lenient(true);
                        viewConfiguration.componentFilter((Spec<? super ComponentIdentifier>)new Spec<ComponentIdentifier>(){

                            @Override
                            public boolean isSatisfiedBy(ComponentIdentifier element) {
                                return element instanceof ProjectComponentIdentifier;
                            }
                        });
                    }
                }).getFiles());
            }
        });
        SourceSetUtil.configureOutputDirectoryForSourceSet(sourceSet, scalaSourceSet.getScala(), project, scalaCompile, scalaCompile.map(new Transformer<CompileOptions, ScalaCompile>(){

            @Override
            public CompileOptions transform(ScalaCompile scalaCompile) {
                return scalaCompile.getOptions();
            }
        }));
        project.getTasks().named(sourceSet.getClassesTaskName(), new Action<Task>(){

            @Override
            public void execute(Task task) {
                task.dependsOn(scalaCompile);
            }
        });
    }

    private static void configureCompileDefaults(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaCompile.class).configureEach(new Action<ScalaCompile>(){

            @Override
            public void execute(final ScalaCompile compile) {
                compile.getConventionMapping().map("scalaClasspath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath(compile.getClasspath());
                    }
                });
                compile.getConventionMapping().map("zincClasspath", new Callable<Configuration>(){

                    @Override
                    public Configuration call() throws Exception {
                        return project.getConfigurations().getAt(ScalaBasePlugin.ZINC_CONFIGURATION_NAME);
                    }
                });
            }
        });
    }

    private static void configureScaladoc(final Project project, final ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaDoc.class).configureEach(new Action<ScalaDoc>(){

            @Override
            public void execute(final ScalaDoc scalaDoc) {
                scalaDoc.getConventionMapping().map("destinationDir", new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        File docsDir = project.getConvention().getPlugin(JavaPluginConvention.class).getDocsDir();
                        return project.file(docsDir.getPath() + "/scaladoc");
                    }
                });
                scalaDoc.getConventionMapping().map("title", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle();
                    }
                });
                scalaDoc.getConventionMapping().map("scalaClasspath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return scalaRuntime.inferScalaClasspath(scalaDoc.getClasspath());
                    }
                });
            }
        });
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        private final ImmutableSet<Usage> expectedUsages;
        private final Usage javaRuntimeJars;

        @Inject
        UsageDisambiguationRules(Usage incrementalAnalysis, Usage javaApi, Usage javaRuntimeJars) {
            this.javaRuntimeJars = javaRuntimeJars;
            this.expectedUsages = ImmutableSet.of((Object)incrementalAnalysis, (Object)javaApi, (Object)javaRuntimeJars);
        }

        @Override
        public void execute(MultipleCandidatesDetails<Usage> details) {
            if (details.getConsumerValue() == null && details.getCandidateValues().equals(this.expectedUsages)) {
                details.closestMatch(this.javaRuntimeJars);
            }
        }
    }
}

