/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;
import org.gradle.util.VersionNumber;

public class PmdPlugin
extends AbstractCodeQualityPlugin<Pmd> {
    public static final String DEFAULT_PMD_VERSION = "6.8.0";
    private PmdExtension extension;

    @Override
    protected String getToolName() {
        return "PMD";
    }

    @Override
    protected Class<Pmd> getTaskType() {
        return Pmd.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("pmd", PmdExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_PMD_VERSION);
        this.extension.setRuleSets(new ArrayList<String>(Arrays.asList("category/java/errorprone.xml")));
        this.extension.setRuleSetFiles(this.project.getLayout().files(new Object[0]));
        PmdPlugin.conventionMappingOf(this.extension).map("targetJdk", new Callable<Object>(){

            @Override
            public Object call() {
                return PmdPlugin.this.getDefaultTargetJdk(PmdPlugin.this.getJavaPluginConvention().getSourceCompatibility());
            }
        });
        return this.extension;
    }

    public TargetJdk getDefaultTargetJdk(JavaVersion javaVersion) {
        try {
            return TargetJdk.toVersion(javaVersion.toString());
        }
        catch (IllegalArgumentException ignored) {
            return TargetJdk.VERSION_1_4;
        }
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Pmd task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                VersionNumber version = VersionNumber.parse(PmdPlugin.this.extension.getToolVersion());
                String dependency = PmdPlugin.this.calculateDefaultDependencyNotation(version);
                dependencies.add(PmdPlugin.this.project.getDependencies().create(dependency));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, Pmd task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("pmdClasspath", Callables.returning((Object)configuration));
        taskMapping.map("ruleSets", new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return PmdPlugin.this.extension.getRuleSets();
            }
        });
        taskMapping.map("ruleSetConfig", new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return PmdPlugin.this.extension.getRuleSetConfig();
            }
        });
        taskMapping.map("ruleSetFiles", new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return PmdPlugin.this.extension.getRuleSetFiles();
            }
        });
        taskMapping.map("ignoreFailures", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return PmdPlugin.this.extension.isIgnoreFailures();
            }
        });
        taskMapping.map("rulePriority", new Callable<Integer>(){

            @Override
            public Integer call() {
                return PmdPlugin.this.extension.getRulePriority();
            }
        });
        taskMapping.map("consoleOutput", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return PmdPlugin.this.extension.isConsoleOutput();
            }
        });
        taskMapping.map("targetJdk", new Callable<TargetJdk>(){

            @Override
            public TargetJdk call() {
                return PmdPlugin.this.extension.getTargetJdk();
            }
        });
    }

    private void configureReportsConventionMapping(Pmd task, final String baseName) {
        task.getReports().all(new Action<SingleFileReport>(){

            @Override
            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = PmdPlugin.conventionMappingOf(report);
                reportMapping.map("enabled", Callables.returning((Object)true));
                reportMapping.map("destination", new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(PmdPlugin.this.extension.getReportsDir(), baseName + "." + report.getName());
                    }
                });
            }
        });
    }

    private String calculateDefaultDependencyNotation(VersionNumber toolVersion) {
        if (toolVersion.compareTo(VersionNumber.version(5)) < 0) {
            return "pmd:pmd:" + this.extension.getToolVersion();
        }
        if (toolVersion.compareTo(VersionNumber.parse("5.2.0")) < 0) {
            return "net.sourceforge.pmd:pmd:" + this.extension.getToolVersion();
        }
        return "net.sourceforge.pmd:pmd-java:" + this.extension.getToolVersion();
    }

    @Override
    protected void configureForSourceSet(final SourceSet sourceSet, Pmd task) {
        task.setDescription("Run PMD analysis for " + sourceSet.getName() + " classes");
        task.setSource(sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("classpath", new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sourceSet.getOutput().plus(sourceSet.getCompileClasspath());
            }
        });
    }
}

