/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.FindBugs;
import org.gradle.api.plugins.quality.FindBugsExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;
import org.gradle.util.SingleMessageLogger;

@Deprecated
public class FindBugsPlugin
extends AbstractCodeQualityPlugin<FindBugs> {
    public static final String DEFAULT_FINDBUGS_VERSION = "3.0.1";
    private FindBugsExtension extension;

    @Override
    protected String getToolName() {
        return "FindBugs";
    }

    @Override
    protected Class<FindBugs> getTaskType() {
        return FindBugs.class;
    }

    @Override
    protected void beforeApply() {
        SingleMessageLogger.nagUserOfPluginReplacedWithExternalOne("findbugs", "com.github.spotbugs");
        this.configureFindBugsConfigurations();
    }

    private void configureFindBugsConfigurations() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create("findbugsPlugins");
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The FindBugs plugins to be used for this project.");
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("findbugs", FindBugsExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_FINDBUGS_VERSION);
        return this.extension;
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(FindBugs task, String baseName) {
        task.setPluginClasspath(this.project.getConfigurations().getAt("findbugsPlugins"));
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                dependencies.add(FindBugsPlugin.this.project.getDependencies().create("com.google.code.findbugs:findbugs:" + FindBugsPlugin.this.extension.getToolVersion()));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, FindBugs task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("findbugsClasspath", Callables.returning((Object)configuration));
        taskMapping.map("ignoreFailures", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return FindBugsPlugin.this.extension.isIgnoreFailures();
            }
        });
        taskMapping.map("effort", new Callable<String>(){

            @Override
            public String call() {
                return FindBugsPlugin.this.extension.getEffort();
            }
        });
        taskMapping.map("reportLevel", new Callable<String>(){

            @Override
            public String call() {
                return FindBugsPlugin.this.extension.getReportLevel();
            }
        });
        taskMapping.map("visitors", new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getVisitors();
            }
        });
        taskMapping.map("omitVisitors", new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getOmitVisitors();
            }
        });
        taskMapping.map("excludeFilterConfig", new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return FindBugsPlugin.this.extension.getExcludeFilterConfig();
            }
        });
        taskMapping.map("includeFilterConfig", new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return FindBugsPlugin.this.extension.getIncludeFilterConfig();
            }
        });
        taskMapping.map("excludeBugsFilterConfig", new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return FindBugsPlugin.this.extension.getExcludeBugsFilterConfig();
            }
        });
        taskMapping.map("extraArgs", new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getExtraArgs();
            }
        });
        taskMapping.map("jvmArgs", new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return FindBugsPlugin.this.extension.getJvmArgs();
            }
        });
        taskMapping.map("showProgress", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return FindBugsPlugin.this.extension.isShowProgress();
            }
        });
    }

    private void configureReportsConventionMapping(FindBugs task, final String baseName) {
        task.getReports().all(new Action<SingleFileReport>(){

            @Override
            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = FindBugsPlugin.conventionMappingOf(report);
                reportMapping.map("enabled", new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return report.getName().equals("xml");
                    }
                });
                reportMapping.map("destination", new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(FindBugsPlugin.this.extension.getReportsDir(), baseName + "." + report.getName());
                    }
                });
            }
        });
    }

    @Override
    protected void configureForSourceSet(final SourceSet sourceSet, FindBugs task) {
        task.setDescription("Run FindBugs analysis for " + sourceSet.getName() + " classes");
        task.setSource(sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("classes", new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sourceSet.getOutput().getClassesDirs();
            }
        });
        taskMapping.map("classpath", new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sourceSet.getCompileClasspath();
            }
        });
    }
}

