/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;

public class CheckstylePlugin
extends AbstractCodeQualityPlugin<Checkstyle> {
    public static final String DEFAULT_CHECKSTYLE_VERSION = "8.12";
    private static final String CONFIG_DIR_NAME = "config/checkstyle";
    private CheckstyleExtension extension;

    @Override
    protected String getToolName() {
        return "Checkstyle";
    }

    @Override
    protected Class<Checkstyle> getTaskType() {
        return Checkstyle.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("checkstyle", CheckstyleExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_CHECKSTYLE_VERSION);
        this.extension.getConfigDirectory().set(this.determineConfigurationDirectory());
        this.extension.setConfig(this.project.getResources().getText().fromFile(new Callable<File>(){

            @Override
            public File call() {
                return new File(CheckstylePlugin.this.extension.getConfigDir(), "checkstyle.xml");
            }
        }));
        return this.extension;
    }

    private Provider<Directory> determineConfigurationDirectory() {
        return this.project.provider(new Callable<Directory>(){

            @Override
            public Directory call() {
                return CheckstylePlugin.this.project.getRootProject().getLayout().getProjectDirectory().dir(CheckstylePlugin.CONFIG_DIR_NAME);
            }
        });
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Checkstyle task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                dependencies.add(CheckstylePlugin.this.project.getDependencies().create("com.puppycrawl.tools:checkstyle:" + CheckstylePlugin.this.extension.getToolVersion()));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, Checkstyle task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("checkstyleClasspath", Callables.returning((Object)configuration));
        taskMapping.map("config", new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return CheckstylePlugin.this.extension.getConfig();
            }
        });
        taskMapping.map("configProperties", new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() {
                return CheckstylePlugin.this.extension.getConfigProperties();
            }
        });
        taskMapping.map("ignoreFailures", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return CheckstylePlugin.this.extension.isIgnoreFailures();
            }
        });
        taskMapping.map("showViolations", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return CheckstylePlugin.this.extension.isShowViolations();
            }
        });
        taskMapping.map("maxErrors", new Callable<Integer>(){

            @Override
            public Integer call() {
                return CheckstylePlugin.this.extension.getMaxErrors();
            }
        });
        taskMapping.map("maxWarnings", new Callable<Integer>(){

            @Override
            public Integer call() {
                return CheckstylePlugin.this.extension.getMaxWarnings();
            }
        });
        task.setConfigDir(this.project.provider(new Callable<File>(){

            @Override
            public File call() {
                return CheckstylePlugin.this.extension.getConfigDir();
            }
        }));
    }

    private void configureReportsConventionMapping(Checkstyle task, final String baseName) {
        task.getReports().all(new Action<SingleFileReport>(){

            @Override
            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = CheckstylePlugin.conventionMappingOf(report);
                reportMapping.map("enabled", Callables.returning((Object)true));
                reportMapping.map("destination", new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(CheckstylePlugin.this.extension.getReportsDir(), baseName + "." + report.getName());
                    }
                });
            }
        });
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Checkstyle task) {
        task.setDescription("Run Checkstyle analysis for " + sourceSet.getName() + " classes");
        task.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
        task.setSource(sourceSet.getAllJava());
    }
}

