/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Cast;

public class SourceSetUtil {
    private SourceSetUtil() {
    }

    public static void configureForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, CompileOptions options, Project target) {
        SourceSetUtil.configureForSourceSet(sourceSet, sourceDirectorySet, compile, target);
        SourceSetUtil.configureAnnotationProcessorPath(sourceSet, sourceDirectorySet, options, target);
    }

    private static void configureForSourceSet(final SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, AbstractCompile compile, final Project target) {
        compile.setDescription("Compiles the " + sourceDirectorySet.getDisplayName() + ".");
        compile.setSource(sourceSet.getJava());
        compile.getConventionMapping().map("classpath", new Callable<Object>(){

            @Override
            public Object call() {
                return sourceSet.getCompileClasspath().plus(target.files(sourceSet.getJava().getOutputDir()));
            }
        });
        compile.setDestinationDir(target.provider(new Callable<File>(){

            @Override
            public File call() {
                return sourceDirectorySet.getOutputDir();
            }
        }));
    }

    public static void configureAnnotationProcessorPath(final SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, CompileOptions options, final Project target) {
        ConventionMapping conventionMapping = new DslObject(options).getConventionMapping();
        conventionMapping.map("annotationProcessorPath", new Callable<Object>(){

            @Override
            public Object call() {
                return sourceSet.getAnnotationProcessorPath();
            }
        });
        final String annotationProcessorGeneratedSourcesChildPath = "generated/sources/annotationProcessor/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        conventionMapping.map("annotationProcessorGeneratedSourcesDirectory", new Callable<Object>(){

            @Override
            public Object call() {
                return new File(target.getBuildDir(), annotationProcessorGeneratedSourcesChildPath);
            }
        });
    }

    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, final Project target, Provider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        final String sourceSetChildPath = "classes/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        sourceDirectorySet.setOutputDir(target.provider(new Callable<File>(){

            @Override
            public File call() {
                return new File(target.getBuildDir(), sourceSetChildPath);
            }
        }));
        DefaultSourceSetOutput sourceSetOutput = Cast.cast(DefaultSourceSetOutput.class, sourceSet.getOutput());
        sourceSetOutput.addClassesDir(new Callable<File>(){

            @Override
            public File call() {
                return sourceDirectorySet.getOutputDir();
            }
        });
        sourceSetOutput.getGeneratedSourcesDirs().from(options.map(new Transformer<Object, CompileOptions>(){

            @Override
            public Object transform(CompileOptions compileOptions) {
                return compileOptions.getAnnotationProcessorGeneratedSourcesDirectory();
            }
        })).builtBy(compileTask);
    }
}

