/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.gradle.internal;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.plugins.buildcomparison.gradle.GradleBuildInvocationSpec;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GradleVersion;

public class DefaultGradleBuildInvocationSpec
implements GradleBuildInvocationSpec {
    private PathToFileResolver fileResolver;
    private Object projectDir;
    private String gradleVersion = GradleVersion.current().getVersion();
    private List<String> tasks = new LinkedList<String>();
    private List<String> arguments = new LinkedList<String>();

    @Inject
    public DefaultGradleBuildInvocationSpec(PathToFileResolver fileResolver, Object projectDir) {
        this.fileResolver = fileResolver;
        this.projectDir = projectDir;
    }

    @Override
    public File getProjectDir() {
        return this.fileResolver.resolve(this.projectDir);
    }

    @Override
    public void setProjectDir(Object projectDir) {
        if (projectDir == null) {
            throw new IllegalArgumentException("projectDir cannot be null");
        }
        this.projectDir = projectDir;
    }

    @Override
    public String getGradleVersion() {
        return this.gradleVersion;
    }

    @Override
    public void setGradleVersion(String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException("gradleVersion cannot be null");
        }
        GradleVersion version = GradleVersion.version(gradleVersion);
        this.gradleVersion = version.getVersion();
    }

    @Override
    public List<String> getTasks() {
        return this.tasks;
    }

    @Override
    public void setTasks(Iterable<String> tasks) {
        this.tasks = tasks == null ? new LinkedList<String>() : Lists.newLinkedList(tasks);
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(Iterable<String> arguments) {
        this.arguments = arguments == null ? new LinkedList<String>() : Lists.newLinkedList(arguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGradleBuildInvocationSpec that = (DefaultGradleBuildInvocationSpec)o;
        if (!this.getArguments().equals(that.getArguments())) {
            return false;
        }
        if (!this.getGradleVersion().equals(that.getGradleVersion())) {
            return false;
        }
        if (!this.getProjectDir().equals(that.getProjectDir())) {
            return false;
        }
        return this.getTasks().equals(that.getTasks());
    }

    public int hashCode() {
        int result = this.getProjectDir().hashCode();
        result = 31 * result + this.getGradleVersion().hashCode();
        result = 31 * result + this.getTasks().hashCode();
        result = 31 * result + this.getArguments().hashCode();
        return result;
    }

    public String toString() {
        return "{dir: '" + this.getProjectDir().getAbsolutePath() + "', tasks: '" + CollectionUtils.join(" ", this.getTasks()) + "', arguments: '" + CollectionUtils.join(" ", this.getArguments()) + "', gradleVersion: " + this.getGradleVersion() + "}";
    }
}

