/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.plugins.announce.Announcer;
import org.gradle.api.plugins.announce.internal.AnnouncerUnavailableException;
import org.gradle.api.plugins.announce.internal.IconProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.util.CollectionUtils;

public class Snarl
implements Announcer {
    private static final float SNP_VERSION = 1.1f;
    private static final String HEAD = "type=SNP#?version=1.1";
    private final IconProvider iconProvider;

    public Snarl(IconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    @Override
    public void send(String title, String message) {
        try {
            this.send(InetAddress.getByName(null), title, message);
        }
        catch (UnknownHostException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private void send(InetAddress host, String title, String message) {
        try (Socket socket = new Socket(host, 9887);
             OutputStream outputStream = socket.getOutputStream();
             PrintWriter printWriter = new PrintWriter(outputStream, true);){
            printWriter.println(this.formatMessage(title, message));
        }
        catch (ConnectException e) {
            throw new AnnouncerUnavailableException("Snarl is not running on host " + String.valueOf(host) + ".", e);
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    private String formatMessage(String title, String message) {
        File icon = this.iconProvider.getIcon(32, 32);
        List<String> properties = Arrays.asList(Snarl.formatProperty("action", "notification"), Snarl.formatProperty("app", "Gradle Snarl Notifier"), Snarl.formatProperty("class", "alert"), Snarl.formatProperty("title", title), Snarl.formatProperty("text", message), Snarl.formatProperty("icon", icon == null ? null : icon.getAbsolutePath()), Snarl.formatProperty("timeout", "10"));
        return HEAD + CollectionUtils.join("", properties) + "\r\n";
    }

    private static String formatProperty(String name, String value) {
        if (value != null && !value.isEmpty()) {
            return "#?" + name + "=" + value;
        }
        return "";
    }
}

