/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.java.DefaultJavaPlatformExtension;
import org.gradle.api.internal.java.JavaPlatform;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlatformExtension;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

@Incubating
public class JavaPlatformPlugin
implements Plugin<Project> {
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String ENFORCED_API_ELEMENTS_CONFIGURATION_NAME = "enforcedApiElements";
    public static final String ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME = "enforcedRuntimeElements";
    public static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private static final Action<Configuration> AS_CONSUMABLE_CONFIGURATION = new Action<Configuration>(){

        @Override
        public void execute(Configuration conf) {
            conf.setCanBeResolved(false);
            conf.setCanBeConsumed(true);
        }
    };
    private static final Action<Configuration> AS_BUCKET = new Action<Configuration>(){

        @Override
        public void execute(Configuration conf) {
            conf.setCanBeResolved(false);
            conf.setCanBeConsumed(false);
        }
    };
    private static final Action<Configuration> AS_RESOLVABLE_CONFIGURATION = new Action<Configuration>(){

        @Override
        public void execute(Configuration conf) {
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
        }
    };
    private static final String DISALLOW_DEPENDENCIES = "Adding dependencies to platforms is not allowed by default.\nMost likely you want to add constraints instead.\nIf you did this intentionally, you need to configure the platform extension to allow dependencies:\n    javaPlatform.allowDependencies()\nFound dependencies in the '%s' configuration.";

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        this.createConfigurations(project);
        this.createSoftwareComponent(project);
        this.configureExtension(project);
        this.addPlatformDisambiguationRule(project);
    }

    private void addPlatformDisambiguationRule(Project project) {
        project.getDependencies().getAttributesSchema().getMatchingStrategy(PlatformSupport.COMPONENT_CATEGORY).getDisambiguationRules().add(PlatformSupport.PreferRegularPlatform.class);
    }

    private boolean createSoftwareComponent(Project project) {
        return project.getComponents().add(project.getObjects().newInstance(JavaPlatform.class, project.getConfigurations()));
    }

    private void createConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration api = configurations.create(API_CONFIGURATION_NAME, AS_BUCKET);
        Configuration apiElements = this.createConsumableApi(project, configurations, api, API_ELEMENTS_CONFIGURATION_NAME, "platform");
        Configuration enforcedApiElements = this.createConsumableApi(project, configurations, api, ENFORCED_API_ELEMENTS_CONFIGURATION_NAME, "enforced-platform");
        Configuration runtime = project.getConfigurations().create(RUNTIME_CONFIGURATION_NAME, AS_BUCKET);
        runtime.extendsFrom(api);
        Configuration runtimeElements = this.createConsumableRuntime(project, runtime, RUNTIME_ELEMENTS_CONFIGURATION_NAME, "platform");
        Configuration enforcedRuntimeElements = this.createConsumableRuntime(project, runtime, ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME, "enforced-platform");
        Configuration classpath = configurations.create(CLASSPATH_CONFIGURATION_NAME, AS_RESOLVABLE_CONFIGURATION);
        classpath.extendsFrom(runtimeElements);
        this.declareConfigurationUsage(project, classpath, "java-runtime");
    }

    private Configuration createConsumableRuntime(Project project, Configuration apiElements, String name, String platformKind) {
        Configuration runtimeElements = project.getConfigurations().create(name, AS_CONSUMABLE_CONFIGURATION);
        runtimeElements.extendsFrom(apiElements);
        this.declareConfigurationUsage(project, runtimeElements, "java-runtime");
        this.declareConfigurationCategory(runtimeElements, platformKind);
        return runtimeElements;
    }

    private Configuration createConsumableApi(Project project, ConfigurationContainer configurations, Configuration api, String name, String platformKind) {
        Configuration apiElements = configurations.create(name, AS_CONSUMABLE_CONFIGURATION);
        apiElements.extendsFrom(api);
        this.declareConfigurationUsage(project, apiElements, "java-api");
        this.declareConfigurationCategory(apiElements, platformKind);
        return apiElements;
    }

    private void declareConfigurationCategory(Configuration configuration, String value) {
        configuration.getAttributes().attribute(PlatformSupport.COMPONENT_CATEGORY, value);
    }

    private void declareConfigurationUsage(Project project, Configuration configuration, String usage) {
        configuration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, project.getObjects().named(Usage.class, usage));
    }

    private void configureExtension(Project project) {
        final DefaultJavaPlatformExtension platformExtension = project.getExtensions().create(JavaPlatformExtension.class, "javaPlatform", DefaultJavaPlatformExtension.class, new Object[0]);
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(Project project) {
                if (!platformExtension.isAllowDependencies()) {
                    JavaPlatformPlugin.this.checkNoDependencies(project);
                }
            }
        });
    }

    private void checkNoDependencies(Project project) {
        this.checkNoDependencies(project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME), Sets.newHashSet());
    }

    private void checkNoDependencies(Configuration configuration, Set<Configuration> visited) {
        if (visited.add(configuration)) {
            if (!configuration.getDependencies().isEmpty()) {
                throw new InvalidUserCodeException(String.format(DISALLOW_DEPENDENCIES, configuration.getName()));
            }
            Set<Configuration> extendsFrom = configuration.getExtendsFrom();
            for (Configuration parent : extendsFrom) {
                this.checkNoDependencies(parent, visited);
            }
        }
    }
}

