/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import java.io.PrintStream;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.processors.StandardOutputRedirector;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.io.LinePerThreadBufferingOutputStream;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.logging.StandardOutputCapture;

public class DefaultStandardOutputRedirector
implements StandardOutputRedirector {
    private PrintStream originalStdOut;
    private PrintStream originalStdErr;
    private final WriteAction stdOut = new WriteAction();
    private final WriteAction stdErr = new WriteAction();
    private final PrintStream redirectedStdOut = new LinePerThreadBufferingOutputStream(this.stdOut);
    private final PrintStream redirectedStdErr = new LinePerThreadBufferingOutputStream(this.stdErr);

    @Override
    public void redirectStandardOutputTo(StandardOutputListener stdOutDestination) {
        this.stdOut.setDestination(stdOutDestination);
    }

    @Override
    public void redirectStandardErrorTo(StandardOutputListener stdErrDestination) {
        this.stdErr.setDestination(stdErrDestination);
    }

    @Override
    public StandardOutputCapture start() {
        if (this.stdOut.destination != null) {
            this.originalStdOut = System.out;
            System.setOut(this.redirectedStdOut);
        }
        if (this.stdErr.destination != null) {
            this.originalStdErr = System.err;
            System.setErr(this.redirectedStdErr);
        }
        return this;
    }

    @Override
    public StandardOutputCapture stop() {
        try {
            if (this.originalStdOut != null) {
                System.setOut(this.originalStdOut);
            }
            if (this.originalStdErr != null) {
                System.setErr(this.originalStdErr);
            }
            this.redirectedStdOut.flush();
            this.redirectedStdErr.flush();
        }
        finally {
            this.originalStdOut = null;
            this.originalStdErr = null;
            this.stdOut.setDestination(new DiscardAction());
            this.stdErr.setDestination(new DiscardAction());
        }
        return this;
    }

    private static class WriteAction
    implements TextStream {
        private StandardOutputListener destination;

        private WriteAction() {
        }

        @Override
        public void text(String message) {
            this.destination.onOutput(message);
        }

        @Override
        public void endOfStream(@Nullable Throwable failure) {
        }

        public void setDestination(StandardOutputListener destination) {
            this.destination = destination;
        }
    }

    private static class DiscardAction
    implements StandardOutputListener {
        private DiscardAction() {
        }

        @Override
        public void onOutput(CharSequence output) {
        }
    }
}

