/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskValidationContext;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.tasks.TaskValidationException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class ValidatingTaskExecuter
implements TaskExecuter {
    private final TaskExecuter executer;

    public ValidatingTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        ArrayList messages = Lists.newArrayList();
        FileResolver resolver = ((ProjectInternal)task.getProject()).getFileResolver();
        DefaultTaskValidationContext validationContext = new DefaultTaskValidationContext(resolver, messages);
        context.getTaskProperties().validate(validationContext);
        if (!messages.isEmpty()) {
            List<String> firstMessages = messages.subList(0, Math.min(5, messages.size()));
            ValidatingTaskExecuter.report(task, firstMessages, state);
            return TaskExecuterResult.NO_REUSED_OUTPUT;
        }
        return this.executer.execute(task, state, context);
    }

    private static void report(Task task, List<String> messages, TaskStateInternal state) {
        ArrayList causes = Lists.newArrayListWithCapacity((int)messages.size());
        for (String message : messages) {
            causes.add(new InvalidUserDataException(message));
        }
        String errorMessage = ValidatingTaskExecuter.getMainMessage(task, messages);
        state.setOutcome(new TaskValidationException(errorMessage, causes));
    }

    private static String getMainMessage(Task task, List<String> messages) {
        if (messages.size() == 1) {
            return String.format("A problem was found with the configuration of %s.", task);
        }
        return String.format("Some problems were found with the configuration of %s.", task);
    }
}

