/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.internal.change.Change;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.DescriptiveChange;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.DefaultExecutionStateChanges;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;

public class ResolveIncrementalChangesTaskExecuter
implements TaskExecuter {
    private final TaskExecuter delegate;

    public ResolveIncrementalChangesTaskExecuter(TaskExecuter delegate) {
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(final TaskInternal task, TaskStateInternal state, final TaskExecutionContext context) {
        ExecutionStateChanges changes = context.getTaskExecutionMode().getRebuildReason().map(new Function<String, ExecutionStateChanges>(){

            @Override
            public ExecutionStateChanges apply(String rebuildReason) {
                return new RebuildExecutionStateChanges(rebuildReason);
            }
        }).orElseGet(new Supplier<ExecutionStateChanges>(){

            @Override
            @Nullable
            public ExecutionStateChanges get() {
                final AfterPreviousExecutionState afterPreviousExecution = context.getAfterPreviousExecution();
                if (afterPreviousExecution == null || context.isOutputRemovedBeforeExecution()) {
                    return null;
                }
                return context.getBeforeExecutionState().map(new Function<BeforeExecutionState, ExecutionStateChanges>(){

                    @Override
                    public ExecutionStateChanges apply(BeforeExecutionState beforeExecution) {
                        return new DefaultExecutionStateChanges(afterPreviousExecution, beforeExecution, new Describable(){

                            @Override
                            public String getDisplayName() {
                                return task.toString();
                            }
                        });
                    }
                }).orElse(null);
            }
        });
        context.setExecutionStateChanges(changes);
        return this.delegate.execute(task, state, context);
    }

    private static class RebuildExecutionStateChanges
    implements ExecutionStateChanges {
        private final Change rebuildChange;

        public RebuildExecutionStateChanges(String rebuildReason) {
            this.rebuildChange = new DescriptiveChange(rebuildReason, new Object[0]);
        }

        @Override
        public Iterable<Change> getInputFilesChanges() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitAllChanges(ChangeVisitor visitor) {
            visitor.visitChange(this.rebuildChange);
        }

        @Override
        public boolean isRebuildRequired() {
            return true;
        }

        @Override
        public AfterPreviousExecutionState getPreviousExecution() {
            throw new UnsupportedOperationException();
        }
    }
}

