/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.function.Function;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.internal.tasks.BuildCacheKeyInputs;
import org.gradle.caching.internal.tasks.TaskCacheKeyCalculator;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.util.Path;

public class ResolveBuildCacheKeyExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(ResolveBuildCacheKeyExecuter.class);
    private static final BuildCacheKeyInputs NO_CACHE_KEY_INPUTS = new BuildCacheKeyInputs(null, null, null, null, null, null);
    public static final TaskOutputCachingBuildCacheKey NO_CACHE_KEY = new TaskOutputCachingBuildCacheKey(){

        @Override
        public boolean isValid() {
            return false;
        }

        public String toString() {
            return "INVALID";
        }

        @Override
        public Path getTaskPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BuildCacheKeyInputs getInputs() {
            return NO_CACHE_KEY_INPUTS;
        }

        @Override
        public byte[] getHashCodeBytes() {
            return null;
        }

        @Override
        public String getDisplayName() {
            return this.toString();
        }
    };
    private final TaskCacheKeyCalculator calculator;
    private final boolean buildCacheDebugLogging;
    private final TaskExecuter delegate;

    public ResolveBuildCacheKeyExecuter(TaskCacheKeyCalculator calculator, boolean buildCacheDebugLogging, TaskExecuter delegate) {
        this.calculator = calculator;
        this.buildCacheDebugLogging = buildCacheDebugLogging;
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskOutputCachingBuildCacheKey cacheKey = this.resolve(task, context);
        context.setBuildCacheKey(cacheKey);
        return this.delegate.execute(task, state, context);
    }

    private TaskOutputCachingBuildCacheKey resolve(final TaskInternal task, TaskExecutionContext context) {
        final TaskProperties taskProperties = context.getTaskProperties();
        return context.getBeforeExecutionState().map(new Function<BeforeExecutionState, TaskOutputCachingBuildCacheKey>(){

            @Override
            public TaskOutputCachingBuildCacheKey apply(BeforeExecutionState beforeExecutionState) {
                TaskOutputCachingBuildCacheKey cacheKey = ResolveBuildCacheKeyExecuter.this.calculator.calculate(task, beforeExecutionState, taskProperties, ResolveBuildCacheKeyExecuter.this.buildCacheDebugLogging);
                if (taskProperties.hasDeclaredOutputs() && cacheKey.isValid()) {
                    LogLevel logLevel = ResolveBuildCacheKeyExecuter.this.buildCacheDebugLogging ? LogLevel.LIFECYCLE : LogLevel.INFO;
                    LOGGER.log(logLevel, "Build cache key for {} is {}", task, cacheKey.getHashCode());
                }
                return cacheKey;
            }
        }).orElse(NO_CACHE_KEY);
    }
}

