/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationResult;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;

public class EventFiringTaskExecuter
implements TaskExecuter {
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskExecutionListener taskExecutionListener;
    private final TaskExecuter delegate;

    public EventFiringTaskExecuter(BuildOperationExecutor buildOperationExecutor, TaskExecutionListener taskExecutionListener, TaskExecuter delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.taskExecutionListener = taskExecutionListener;
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(final TaskInternal task, final TaskStateInternal state, final TaskExecutionContext context) {
        return this.buildOperationExecutor.call(new CallableBuildOperation<TaskExecuterResult>(){

            @Override
            public TaskExecuterResult call(BuildOperationContext operationContext) {
                TaskExecuterResult result = this.executeTask(operationContext);
                operationContext.setStatus(state.getFailure() != null ? "FAILED" : state.getSkipMessage());
                operationContext.failed(state.getFailure());
                return result;
            }

            private TaskExecuterResult executeTask(BuildOperationContext operationContext) {
                try {
                    EventFiringTaskExecuter.this.taskExecutionListener.beforeExecute(task);
                }
                catch (Throwable t) {
                    state.setOutcome(new TaskExecutionException(task, t));
                    return TaskExecuterResult.NO_REUSED_OUTPUT;
                }
                TaskExecuterResult result = EventFiringTaskExecuter.this.delegate.execute(task, state, context);
                operationContext.setResult(new ExecuteTaskBuildOperationResult(state, context, result.getReusedOutputOriginMetadata().orElse(null)));
                try {
                    EventFiringTaskExecuter.this.taskExecutionListener.afterExecute(task, state);
                }
                catch (Throwable t) {
                    state.addFailure(new TaskExecutionException(task, t));
                }
                return result;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                ExecuteTaskBuildOperationDetails taskOperation = new ExecuteTaskBuildOperationDetails(context.getLocalTaskNode());
                return BuildOperationDescriptor.displayName("Task " + task.getIdentityPath()).name(task.getIdentityPath().toString()).progressDisplayName(task.getIdentityPath().toString()).operationType(BuildOperationCategory.TASK).details(taskOperation);
            }
        });
    }
}

