/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.operations.ExecutingBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class DefaultTaskExecutionContext
implements TaskExecutionContext {
    private final LocalTaskNode localTaskNode;
    private AfterPreviousExecutionState afterPreviousExecution;
    private OverlappingOutputs overlappingOutputs;
    private ExecutionStateChanges executionStateChanges;
    private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFilesBeforeExecution;
    private BeforeExecutionState beforeExecutionState;
    private TaskExecutionMode taskExecutionMode;
    private boolean outputRemovedBeforeExecution;
    private TaskOutputCachingBuildCacheKey buildCacheKey;
    private List<String> upToDateMessages;
    private TaskProperties taskProperties;
    private boolean taskCachingEnabled;
    private Long executionTime;
    private ExecutingBuildOperation snapshotTaskInputsBuildOperation;
    private final Timer executionTimer;
    private boolean taskExecutedIncrementally;

    public DefaultTaskExecutionContext(LocalTaskNode localTaskNode) {
        this.localTaskNode = localTaskNode;
        this.executionTimer = Time.startTimer();
    }

    @Override
    public LocalTaskNode getLocalTaskNode() {
        return this.localTaskNode;
    }

    @Override
    @Nullable
    public AfterPreviousExecutionState getAfterPreviousExecution() {
        return this.afterPreviousExecution;
    }

    @Override
    public void setAfterPreviousExecution(@Nullable AfterPreviousExecutionState afterPreviousExecution) {
        this.afterPreviousExecution = afterPreviousExecution;
    }

    @Override
    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getOutputFilesBeforeExecution() {
        return this.outputFilesBeforeExecution;
    }

    @Override
    public void setOutputFilesBeforeExecution(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFilesBeforeExecution) {
        this.outputFilesBeforeExecution = outputFilesBeforeExecution;
    }

    @Override
    public Optional<OverlappingOutputs> getOverlappingOutputs() {
        return Optional.ofNullable(this.overlappingOutputs);
    }

    @Override
    public void setOverlappingOutputs(OverlappingOutputs overlappingOutputs) {
        this.overlappingOutputs = overlappingOutputs;
    }

    @Override
    public Optional<BeforeExecutionState> getBeforeExecutionState() {
        return Optional.ofNullable(this.beforeExecutionState);
    }

    @Override
    public void setBeforeExecutionState(BeforeExecutionState beforeExecutionState) {
        this.beforeExecutionState = beforeExecutionState;
    }

    @Override
    public TaskExecutionMode getTaskExecutionMode() {
        return this.taskExecutionMode;
    }

    @Override
    public void setTaskExecutionMode(TaskExecutionMode taskExecutionMode) {
        this.taskExecutionMode = taskExecutionMode;
    }

    @Override
    public boolean isOutputRemovedBeforeExecution() {
        return this.outputRemovedBeforeExecution;
    }

    @Override
    public void setOutputRemovedBeforeExecution(boolean outputRemovedBeforeExecution) {
        this.outputRemovedBeforeExecution = outputRemovedBeforeExecution;
    }

    @Override
    public Optional<ExecutionStateChanges> getExecutionStateChanges() {
        return Optional.ofNullable(this.executionStateChanges);
    }

    @Override
    public void setExecutionStateChanges(ExecutionStateChanges executionStateChanges) {
        this.executionStateChanges = executionStateChanges;
    }

    @Override
    public TaskOutputCachingBuildCacheKey getBuildCacheKey() {
        return this.buildCacheKey;
    }

    @Override
    public void setBuildCacheKey(TaskOutputCachingBuildCacheKey buildCacheKey) {
        this.buildCacheKey = buildCacheKey;
    }

    @Override
    public long markExecutionTime() {
        if (this.executionTime != null) {
            throw new IllegalStateException("execution time already set");
        }
        this.executionTime = this.executionTimer.getElapsedMillis();
        return this.executionTime;
    }

    @Override
    public long getExecutionTime() {
        if (this.executionTime == null) {
            throw new IllegalStateException("execution time not yet set");
        }
        return this.executionTime;
    }

    @Override
    @Nullable
    public List<String> getUpToDateMessages() {
        return this.upToDateMessages;
    }

    @Override
    public void setUpToDateMessages(List<String> upToDateMessages) {
        this.upToDateMessages = upToDateMessages;
    }

    @Override
    public void setTaskProperties(TaskProperties taskProperties) {
        this.taskProperties = taskProperties;
    }

    @Override
    public TaskProperties getTaskProperties() {
        return this.taskProperties;
    }

    @Override
    public boolean isTaskCachingEnabled() {
        return this.taskCachingEnabled;
    }

    @Override
    public void setTaskCachingEnabled(boolean taskCachingEnabled) {
        this.taskCachingEnabled = taskCachingEnabled;
    }

    @Override
    public boolean isTaskExecutedIncrementally() {
        return this.taskExecutedIncrementally;
    }

    @Override
    public void setTaskExecutedIncrementally(boolean taskExecutedIncrementally) {
        this.taskExecutedIncrementally = taskExecutedIncrementally;
    }

    @Override
    public Optional<ExecutingBuildOperation> removeSnapshotTaskInputsBuildOperation() {
        Optional<ExecutingBuildOperation> result = Optional.ofNullable(this.snapshotTaskInputsBuildOperation);
        this.snapshotTaskInputsBuildOperation = null;
        return result;
    }

    @Override
    public void setSnapshotTaskInputsBuildOperation(ExecutingBuildOperation snapshotTaskInputsBuildOperation) {
        this.snapshotTaskInputsBuildOperation = snapshotTaskInputsBuildOperation;
    }
}

