/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AnnotationProcessorChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.ResourceChangeProcessor;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.FileUtils;

class InputChangeAction
implements Action<InputFileDetails> {
    private final RecompilationSpec spec;
    private final JavaChangeProcessor javaChangeProcessor;
    private final AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor;
    private final ResourceChangeProcessor resourceChangeProcessor;

    InputChangeAction(RecompilationSpec spec, JavaChangeProcessor javaChangeProcessor, AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor, ResourceChangeProcessor resourceChangeProcessor) {
        this.spec = spec;
        this.javaChangeProcessor = javaChangeProcessor;
        this.annotationProcessorChangeProcessor = annotationProcessorChangeProcessor;
        this.resourceChangeProcessor = resourceChangeProcessor;
    }

    @Override
    public void execute(InputFileDetails input) {
        if (this.spec.getFullRebuildCause() != null) {
            return;
        }
        File file = input.getFile();
        if (FileUtils.hasExtension(file, ".java")) {
            this.javaChangeProcessor.processChange(input, this.spec);
        } else if (FileUtils.hasExtension(file, ".jar") || FileUtils.hasExtension(file, ".class")) {
            this.annotationProcessorChangeProcessor.processChange(input, this.spec);
        } else {
            this.resourceChangeProcessor.processChange(input, this.spec);
        }
    }
}

