/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionLeafVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

@NonNullApi
public class CompilationSourceDirs {
    private static final Logger LOG = Logging.getLogger(CompilationSourceDirs.class);
    private final FileTreeInternal sources;
    private SourceRoots sourceRoots;

    public CompilationSourceDirs(FileTreeInternal sources) {
        this.sources = sources;
    }

    public List<File> getSourceRoots() {
        return this.resolveRoots().getSourceRoots();
    }

    public boolean canInferSourceRoots() {
        return this.resolveRoots().isCanInferSourceRoots();
    }

    private SourceRoots resolveRoots() {
        if (this.sourceRoots == null) {
            SourceRoots visitor = new SourceRoots();
            this.sources.visitLeafCollections(visitor);
            this.sourceRoots = visitor;
        }
        return this.sourceRoots;
    }

    private static class SourceRoots
    implements FileCollectionLeafVisitor {
        private boolean canInferSourceRoots = true;
        private List<File> sourceRoots = Lists.newArrayList();

        private SourceRoots() {
        }

        @Override
        public void visitCollection(FileCollectionInternal fileCollection) {
            this.cannotInferSourceRoots(fileCollection);
        }

        @Override
        public void visitGenericFileTree(FileTreeInternal fileTree) {
            this.cannotInferSourceRoots(fileTree);
        }

        @Override
        public void visitFileTree(File root, PatternSet patterns) {
            if (!root.exists() || root.isDirectory()) {
                this.sourceRoots.add(root);
            } else {
                this.cannotInferSourceRoots("file '" + root + "'");
            }
        }

        private void cannotInferSourceRoots(Object fileCollection) {
            this.canInferSourceRoots = false;
            LOG.info("Cannot infer source root(s) for source `{}`. Supported types are `File` (directories only), `DirectoryTree` and `SourceDirectorySet`.", fileCollection);
        }

        public boolean isCanInferSourceRoots() {
            return this.canInferSourceRoots;
        }

        public List<File> getSourceRoots() {
            return this.sourceRoots;
        }
    }
}

