/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.classpath.DefaultClasspathEntrySnapshotter;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.snapshot.FileSystemSnapshotter;

public class CachingClasspathEntrySnapshotter
implements ClasspathEntrySnapshotter {
    private final DefaultClasspathEntrySnapshotter snapshotter;
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final ClasspathEntrySnapshotCache cache;

    public CachingClasspathEntrySnapshotter(FileHasher fileHasher, StreamHasher streamHasher, FileSystemSnapshotter fileSystemSnapshotter, ClassDependenciesAnalyzer analyzer, ClasspathEntrySnapshotCache cache, FileOperations fileOperations) {
        this.snapshotter = new DefaultClasspathEntrySnapshotter(fileHasher, streamHasher, analyzer, fileOperations);
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.cache = cache;
    }

    @Override
    public ClasspathEntrySnapshot createSnapshot(final File classpathEntry) {
        final HashCode hash = this.getHash(classpathEntry);
        return this.cache.get(classpathEntry, new Factory<ClasspathEntrySnapshot>(){

            @Override
            public ClasspathEntrySnapshot create() {
                return CachingClasspathEntrySnapshotter.this.snapshotter.createSnapshot(hash, classpathEntry);
            }
        });
    }

    private HashCode getHash(File classpathEntry) {
        return this.fileSystemSnapshotter.snapshot(classpathEntry).getHash();
    }
}

